"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDevicePowerActionModel = exports.prepareDevicePowerActionTable = exports.devicePowerActionCollection = void 0;
const collections_1 = require("../../Lib/collections");
const devicePowerActionCollection = (conn) => conn.connection.collection(collections_1.DeviceCollection.PowerAction);
exports.devicePowerActionCollection = devicePowerActionCollection;
const prepareDevicePowerActionTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.devicePowerActionCollection)(conn).createIndex({ uid: 1 }, { name: 'uid', unique: true, background: true });
    yield (0, exports.devicePowerActionCollection)(conn).createIndex({ deviceIdentityHash: 1 }, { name: 'deviceIdentityHash', background: true });
    yield (0, exports.devicePowerActionCollection)(conn).createIndex({ deviceIdentityHash: 1, createdAt: -1 }, { name: 'deviceIdentityHash_createdAt-1', background: true });
    yield (0, exports.devicePowerActionCollection)(conn).createIndex({
        deviceIdentityHash: 1,
        powerType: 1,
        succeededAt: 1,
        failedAt: 1,
    }, { name: 'deviceIdentityHash_powerType_succeededAt_failedAt', background: true });
});
exports.prepareDevicePowerActionTable = prepareDevicePowerActionTable;
const createDevicePowerActionModel = (conn) => ({
    create(uid, deviceIdentityHash, powerType, createdAt) {
        return __awaiter(this, void 0, void 0, function* () {
            const row = {
                uid,
                deviceIdentityHash,
                createdAt,
                powerType,
                succeededAt: null,
                failedAt: null,
            };
            yield (0, exports.devicePowerActionCollection)(conn).insertOne(row, { session: conn.session });
        });
    },
    markFailed(devicePowerActionRow, failedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.devicePowerActionCollection)(conn).updateOne({
                uid: devicePowerActionRow.uid,
            }, {
                $set: {
                    failedAt,
                },
            }, { session: conn.session });
        });
    },
    markSucceed(devicePowerActionRow, succeededAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.devicePowerActionCollection)(conn).updateOne({
                uid: devicePowerActionRow.uid,
            }, {
                $set: {
                    succeededAt,
                },
            }, { session: conn.session });
        });
    },
    fetchByUid(uid) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield (0, exports.devicePowerActionCollection)(conn).findOne({ uid }, { session: conn.session });
        });
    },
    fetchLatestListByDevices(devices, limit) {
        return __awaiter(this, void 0, void 0, function* () {
            const identityHashes = devices.map((device) => device.identityHash);
            return yield (0, exports.devicePowerActionCollection)(conn)
                .find({
                deviceIdentityHash: { $in: identityHashes },
            }, {
                sort: { createdAt: -1 },
                limit,
                session: conn.session,
            })
                .toArray();
        });
    },
    fetchListByDevice(device) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield (0, exports.devicePowerActionCollection)(conn)
                .find({
                deviceIdentityHash: device.identityHash,
            }, {
                session: conn.session,
            })
                .toArray();
        });
    },
    fetchListByDevices(devices) {
        return __awaiter(this, void 0, void 0, function* () {
            const identityHashes = devices.map((device) => device.identityHash);
            return yield (0, exports.devicePowerActionCollection)(conn)
                .find({
                deviceIdentityHash: { $in: identityHashes },
            }, {
                session: conn.session,
            })
                .toArray();
        });
    },
    fetchUnfinishedListByDeviceAndType(device, powerType) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield (0, exports.devicePowerActionCollection)(conn)
                .find({
                deviceIdentityHash: device.identityHash,
                powerType,
                succeededAt: null,
                failedAt: null,
            }, {
                session: conn.session,
            })
                .toArray();
        });
    },
});
exports.createDevicePowerActionModel = createDevicePowerActionModel;
//# sourceMappingURL=devicePowerActionModel.js.map