"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDevicePolicyStatusModel = exports.prepareDevicePolicyStatusTable = exports.devicePolicyStatusCollection = void 0;
const collections_1 = require("../../Lib/collections");
const devicePolicyStatusCollection = (conn) => conn.connection.collection(collections_1.DeviceCollection.PolicyStatus);
exports.devicePolicyStatusCollection = devicePolicyStatusCollection;
const prepareDevicePolicyStatusTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.devicePolicyStatusCollection)(conn).createIndex({ deviceIdentityHash: 1 }, { name: 'deviceIdentityHash', background: true });
    yield (0, exports.devicePolicyStatusCollection)(conn).createIndex({ deviceIdentityHash: 1, itemType: 1 }, {
        name: 'deviceIdentityHash_itemType',
        background: true,
    });
    yield (0, exports.devicePolicyStatusCollection)(conn).createIndex({ deviceIdentityHash: 1, policyUid: 1 }, { name: 'deviceIdentityHash_policyUid', background: true });
    yield (0, exports.devicePolicyStatusCollection)(conn).createIndex({ deviceIdentityHash: 1, policyUid: 1, itemType: 1 }, {
        name: 'deviceIdentityHash_policyUid_itemType',
        background: true,
        unique: true,
    });
    yield (0, exports.devicePolicyStatusCollection)(conn).createIndex({ policyUid: 1, itemType: 1 }, { name: 'policyUid_itemType', background: true });
});
exports.prepareDevicePolicyStatusTable = prepareDevicePolicyStatusTable;
const createDevicePolicyStatusModel = (conn) => ({
    fetchByDeviceAndPolicyAndItemType(device, policy, itemType) {
        return (0, exports.devicePolicyStatusCollection)(conn).findOne({ deviceIdentityHash: device.identityHash, policyUid: policy.uid, itemType }, { session: conn.session });
    },
    fetchListByDeviceAndPolicy(device, policy) {
        return (0, exports.devicePolicyStatusCollection)(conn)
            .find({ deviceIdentityHash: device.identityHash, policyUid: policy.uid })
            .toArray();
    },
    fetchListByDeviceAndItemType(device, itemType) {
        return (0, exports.devicePolicyStatusCollection)(conn).find({ deviceIdentityHash: device.identityHash, itemType }).toArray();
    },
    fetchListByDevice(device) {
        return (0, exports.devicePolicyStatusCollection)(conn).find({ deviceIdentityHash: device.identityHash }).toArray();
    },
    upsert(device, policy, itemType, success, updatedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.devicePolicyStatusCollection)(conn).updateOne({
                deviceIdentityHash: device.identityHash,
                policyUid: policy.uid,
                itemType,
            }, {
                $setOnInsert: {
                    deviceIdentityHash: device.identityHash,
                    policyUid: policy.uid,
                    itemType,
                },
                $set: {
                    success,
                    updatedAt,
                },
            }, { session: conn.session, upsert: true });
        });
    },
    remove(devicePolicyStatusRow) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.devicePolicyStatusCollection)(conn).deleteOne({
                deviceIdentityHash: devicePolicyStatusRow.deviceIdentityHash,
                policyUid: devicePolicyStatusRow.policyUid,
                itemType: devicePolicyStatusRow.itemType,
            }, { session: conn.session });
        });
    },
    removeByDeviceAndPolicy(device, policy) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.devicePolicyStatusCollection)(conn).deleteMany({ deviceIdentityHash: device.identityHash, policyUid: policy.uid }, { session: conn.session });
        });
    },
    removeByPolicyAndItemType(policy, itemType) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.devicePolicyStatusCollection)(conn).deleteMany({ policyUid: policy.uid, itemType }, { session: conn.session });
        });
    },
});
exports.createDevicePolicyStatusModel = createDevicePolicyStatusModel;
//# sourceMappingURL=devicePolicyStatusModel.js.map