"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDevicePackageStartModel = exports.prepareDevicePackageStartTable = exports.devicePackageStartCollection = void 0;
const collections_1 = require("../../Lib/collections");
const devicePackageStartCollection = (conn) => conn.connection.collection(collections_1.DeviceCollection.PackageStart);
exports.devicePackageStartCollection = devicePackageStartCollection;
const prepareDevicePackageStartTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.devicePackageStartCollection)(conn).createIndex('uid', { name: 'uid', unique: true, background: true });
    yield (0, exports.devicePackageStartCollection)(conn).createIndex('deviceIdentityHash', { name: 'deviceIdentityHash', background: true });
    yield (0, exports.devicePackageStartCollection)(conn).createIndex('createdAt', { name: 'createdAt', background: true });
    yield (0, exports.devicePackageStartCollection)(conn).createIndex('packageName', { name: 'packageName', background: true });
    yield (0, exports.devicePackageStartCollection)(conn).createIndex('succeededAt', { name: 'succeededAt', background: true });
    yield (0, exports.devicePackageStartCollection)(conn).createIndex('failedAt', { name: 'failedAt', background: true });
});
exports.prepareDevicePackageStartTable = prepareDevicePackageStartTable;
const createDevicePackageStartModel = (conn) => ({
    fetchByUid(uid) {
        return (0, exports.devicePackageStartCollection)(conn).findOne({ uid }, { session: conn.session });
    },
    fetchByDevice(device) {
        return (0, exports.devicePackageStartCollection)(conn).findOne({ deviceIdentityHash: device.identityHash }, { session: conn.session });
    },
    fetchLatestListByDevices(devices) {
        return __awaiter(this, void 0, void 0, function* () {
            const devicesIdentityHashes = devices.map((device) => device.identityHash);
            const latestListByDevices = yield (0, exports.devicePackageStartCollection)(conn)
                .find({ deviceIdentityHash: { $in: devicesIdentityHashes } }, { session: conn.session })
                .sort({ createdAt: -1 })
                .toArray();
            return latestListByDevices || [];
        });
    },
    create(uid, device, packageName, createdAt) {
        return __awaiter(this, void 0, void 0, function* () {
            const newRow = {
                uid,
                createdAt,
                packageName,
                deviceIdentityHash: device.identityHash,
                succeededAt: null,
                failedAt: null,
            };
            yield (0, exports.devicePackageStartCollection)(conn).insertOne(newRow, { session: conn.session });
        });
    },
    markSucceeded(devicePackageStartRow, succeededAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.devicePackageStartCollection)(conn).updateOne({ uid: devicePackageStartRow.uid }, { $set: { succeededAt } }, { session: conn.session });
        });
    },
    markFailed(devicePackageStartRow, failedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.devicePackageStartCollection)(conn).updateOne({ uid: devicePackageStartRow.uid }, { $set: { failedAt } }, { session: conn.session });
        });
    },
    fetchListByPropertyFilter(propertyFilter) {
        return __awaiter(this, void 0, void 0, function* () {
            let latestListByDevices = [];
            if (propertyFilter.deviceIdentityHash) {
                latestListByDevices = yield (0, exports.devicePackageStartCollection)(conn)
                    .find({ deviceIdentityHash: propertyFilter.deviceIdentityHash }, { session: conn.session })
                    .sort({ createdAt: -1 })
                    .toArray();
            }
            return latestListByDevices || [];
        });
    },
});
exports.createDevicePackageStartModel = createDevicePackageStartModel;
//# sourceMappingURL=devicePackageStartModel.js.map