"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceNoteModel = exports.prepareDeviceNoteTable = exports.deviceNoteCollection = void 0;
const collections_1 = require("../../Lib/collections");
const deviceNoteCollection = (conn) => conn.connection.collection(collections_1.DeviceCollection.Note);
exports.deviceNoteCollection = deviceNoteCollection;
const prepareDeviceNoteTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.deviceNoteCollection)(conn).createIndex({ uid: 1 }, { name: 'uid', unique: true, background: true });
    yield (0, exports.deviceNoteCollection)(conn).createIndex({ deviceIdentityHash: 1 }, { name: 'deviceIdentityHash', unique: false, background: true });
    yield (0, exports.deviceNoteCollection)(conn).createIndex({ accountId: 1 }, { name: 'accountId', unique: false, background: true });
    yield (0, exports.deviceNoteCollection)(conn).createIndex({ createdAt: -1 }, { name: 'createdAt', unique: false, background: true });
});
exports.prepareDeviceNoteTable = prepareDeviceNoteTable;
const createDeviceNoteModel = (conn) => ({
    create(uid, deviceIdentityHash, accountId, note, createdAt) {
        return __awaiter(this, void 0, void 0, function* () {
            const newDeviceNoteRow = {
                uid,
                deviceIdentityHash,
                accountId,
                note,
                createdAt,
            };
            yield (0, exports.deviceNoteCollection)(conn).insertOne(newDeviceNoteRow);
        });
    },
    fetchByUid(uid) {
        return (0, exports.deviceNoteCollection)(conn).findOne({ uid });
    },
    fetchListByDeviceIdentityHash(deviceIdentityHash) {
        const query = (0, exports.deviceNoteCollection)(conn).find({
            deviceIdentityHash,
            archivedAt: {
                $exists: false,
            },
        });
        return query.sort({ createdAt: -1 }).toArray();
    },
    fetchListByDeviceIdentityHashes(deviceIdentityHashes) {
        const query = (0, exports.deviceNoteCollection)(conn).find({
            deviceIdentityHash: {
                $in: deviceIdentityHashes,
            },
            archivedAt: {
                $exists: false,
            },
        });
        return query.sort({ createdAt: -1 }).toArray();
    },
    archive(deviceNoteRow, archivedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.deviceNoteCollection)(conn).updateOne({ uid: deviceNoteRow.uid }, {
                $set: {
                    archivedAt,
                },
            });
        });
    },
});
exports.createDeviceNoteModel = createDeviceNoteModel;
//# sourceMappingURL=deviceNoteModel.js.map