"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceMonitoringLogLatestModel = exports.prepareDeviceMonitoringLogLatestTable = exports.deviceMonitoringLogLatestCollection = void 0;
const escape_1 = require("@signageos/lib/dist/MongoDB/escape");
const pagination_1 = require("../../Lib/Pagination/pagination");
const utils_1 = require("../../Lib/utils");
const versions_1 = require("../../../Helpers/versions");
const monitoringLog_utils_1 = require("./monitoringLog.utils");
const errors_1 = require("../../../Schema/Device/MonitoringLog/errors");
const dataType_1 = require("../../../Schema/Device/MonitoringLog/dataType");
const collections_1 = require("../../Lib/collections");
const DeviceTelemetryType_1 = require("@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType");
/**
 * Returns a MongoDB collection object for the `deviceMonitoringState` collection.
 * @param {IMongodbConnection} conn - IMongodbConnection - MongoDB connection object
 */
const deviceMonitoringLogLatestCollection = (conn) => conn.connection.collection(collections_1.DeviceCollection.MonitoringState);
exports.deviceMonitoringLogLatestCollection = deviceMonitoringLogLatestCollection;
const prepareDeviceMonitoringLogLatestTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.deviceMonitoringLogLatestCollection)(conn).createIndex({ id: 1 }, { name: 'id', unique: true, background: true });
    yield (0, exports.deviceMonitoringLogLatestCollection)(conn).createIndex({ deviceIdentityHash: 1 }, { name: 'device', background: true });
    yield (0, exports.deviceMonitoringLogLatestCollection)(conn).createIndex({ deviceIdentityHash: 1, type: 1 }, { name: 'device_type', background: true });
    yield (0, exports.deviceMonitoringLogLatestCollection)(conn).createIndex({ deviceIdentityHash: 1, type: 1, createdAt: -1 }, { name: 'device_type_createdAt', background: true });
});
exports.prepareDeviceMonitoringLogLatestTable = prepareDeviceMonitoringLogLatestTable;
/**
 * Creates device telemetry model with methods only for inserting or getting the latest values.
 * @param {IMongodbConnection} conn - IMongodbConnection - the connection to the database
 * @returns All model functions
 */
const createDeviceMonitoringLogLatestModel = (conn) => ({
    fetchLatestByDeviceAndType(device, type) {
        return __awaiter(this, void 0, void 0, function* () {
            const filter = {
                deviceIdentityHash: device.identityHash,
                type,
            };
            const options = {
                sort: { createdAt: -1 },
                session: conn.session,
            };
            return (0, exports.deviceMonitoringLogLatestCollection)(conn).findOne(filter, options);
        });
    },
    fetchLatestByIdentityHashAndType(identityHash, type) {
        return __awaiter(this, void 0, void 0, function* () {
            const filter = {
                deviceIdentityHash: identityHash,
                type,
            };
            const options = {
                sort: { createdAt: -1 },
                session: conn.session,
            };
            return (0, exports.deviceMonitoringLogLatestCollection)(conn).findOne(filter, options);
        });
    },
    create(id, type, device, createdAt, data) {
        return __awaiter(this, void 0, void 0, function* () {
            // To standardize application version with fields in device model which are stored also as number to simplify filtering
            if (type === DeviceTelemetryType_1.DeviceTelemetryType.APPLICATION_VERSION) {
                const appVersionData = data;
                try {
                    appVersionData.versionNumber = (0, versions_1.numberizeStrictly)(appVersionData.version);
                }
                catch (error) {
                    throw new errors_1.InvalidMonitoringLogPropertyValueError('version', dataType_1.DataType.STRING, appVersionData.version);
                }
            }
            const filter = {
                deviceIdentityHash: device.identityHash,
                type,
            };
            const payload = {
                id,
                deviceIdentityHash: device.identityHash,
                type,
                createdAt,
                data: (0, escape_1.escapeObject)(data),
            };
            yield (0, exports.deviceMonitoringLogLatestCollection)(conn).updateOne(filter, {
                $set: payload,
            }, { session: conn.session, upsert: true });
        });
    },
    createMany(_monitoringLogs) {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error(`Not implemented method.`);
        });
    },
    invalidate(type, device) {
        return __awaiter(this, void 0, void 0, function* () {
            const filter = {
                deviceIdentityHash: device.identityHash,
                type,
            };
            yield (0, exports.deviceMonitoringLogLatestCollection)(conn).deleteOne(filter, { session: conn.session });
        });
    },
    fetchLatestByDevicesAndType(deviceIdentityHashes, type) {
        return __awaiter(this, void 0, void 0, function* () {
            const matcher = {
                deviceIdentityHash: {
                    $in: deviceIdentityHashes,
                },
                type,
            };
            const { sorter } = (0, pagination_1.createSorterWithPaginator)({
                sort: { field: 'createdAt', order: 'descending' },
            });
            const pipeline = (0, utils_1.getPipelineLegacy)({ matcher, sorter });
            const aggregationCursor = (0, exports.deviceMonitoringLogLatestCollection)(conn).aggregate(pipeline, {
                session: conn.session,
            });
            const paginatedAggregationCursor = (0, pagination_1.getPaginatedAggregationCursor)({
                aggregationCursor,
            });
            const monitoringLogs = yield paginatedAggregationCursor.toArray();
            return monitoringLogs;
        });
    },
    fetchLatestListByDevices({ devices, filter, sort, pagination, }) {
        return __awaiter(this, void 0, void 0, function* () {
            const matcher = {
                deviceIdentityHash: {
                    $in: devices.map((device) => device.identityHash),
                },
            };
            const sortWithDefault = (0, monitoringLog_utils_1.getDefaultSort)(sort);
            const { sorter, paginator } = (0, pagination_1.createSorterWithPaginator)({
                sort: sortWithDefault,
                pagination,
                since: filter === null || filter === void 0 ? void 0 : filter.since,
                until: filter === null || filter === void 0 ? void 0 : filter.until,
            });
            const pipeline = (0, utils_1.getPipelineLegacy)({ matcher, sorter, paginator });
            const aggregationCursor = (0, exports.deviceMonitoringLogLatestCollection)(conn).aggregate(pipeline, {
                session: conn.session,
            });
            const paginatedAggregationCursor = (0, pagination_1.getPaginatedAggregationCursor)({
                aggregationCursor,
                pagination,
            });
            const monitoringLogs = yield paginatedAggregationCursor.toArray();
            return monitoringLogs;
        });
    },
});
exports.createDeviceMonitoringLogLatestModel = createDeviceMonitoringLogLatestModel;
//# sourceMappingURL=deviceMonitoringLogLatestModel.js.map