/// <reference types="mongoose/types/aggregate" />
/// <reference types="mongoose/types/callback" />
/// <reference types="mongoose/types/collection" />
/// <reference types="mongoose/types/connection" />
/// <reference types="mongoose/types/cursor" />
/// <reference types="mongoose/types/document" />
/// <reference types="mongoose/types/error" />
/// <reference types="mongoose/types/expressions" />
/// <reference types="mongoose/types/helpers" />
/// <reference types="mongoose/types/middlewares" />
/// <reference types="mongoose/types/indexes" />
/// <reference types="mongoose/types/models" />
/// <reference types="mongoose/types/mongooseoptions" />
/// <reference types="mongoose/types/pipelinestage" />
/// <reference types="mongoose/types/populate" />
/// <reference types="mongoose/types/query" />
/// <reference types="mongoose/types/schemaoptions" />
/// <reference types="mongoose/types/schematypes" />
/// <reference types="mongoose/types/session" />
/// <reference types="mongoose/types/types" />
/// <reference types="mongoose/types/utility" />
/// <reference types="mongoose/types/validation" />
/// <reference types="mongoose/types/virtuals" />
/// <reference types="mongoose" />
/// <reference types="mongoose/types/inferschematype" />
import { IMongodbConnection } from '@signageos/lib/dist/MongoDB/mongoDBConnectionFactory';
import { IDeviceMonitoringLog, IDeviceMonitoringLogModelLatest, IDeviceMonitoringLogModelStats, IDeviceMonitoringLogModelWrite } from '../../../Schema/Device/MonitoringLog/deviceMonitoringLogModel';
import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
/**
 * There has to be a little different structure of the row in the database, because of the timeseries collection.
 * It contains the `metadata` field with all the data that will be queried.
 * @protected - This type is not intended to be used outside of this file. Only for testing purposes.
 */
export declare type IDeviceMonitoringLogRow<Type extends DeviceTelemetryType = DeviceTelemetryType> = Pick<IDeviceMonitoringLog<Type>, 'id' | 'createdAt' | 'data'> & {
    metadata: Pick<IDeviceMonitoringLog<Type>, 'type' | 'deviceIdentityHash' | 'organizationUid'>;
};
export declare function convertRowToEntity<Type extends DeviceTelemetryType = DeviceTelemetryType>(row: IDeviceMonitoringLogRow<Type>): IDeviceMonitoringLog<Type>;
export declare function convertEntityToRow<Type extends DeviceTelemetryType = DeviceTelemetryType>(entity: IDeviceMonitoringLog<Type>): IDeviceMonitoringLogRow<Type>;
/**
 * Returns a MongoDB collection object for the `deviceMonitoringLog` collection.
 * @param {IMongodbConnection} conn - IMongodbConnection - MongoDB connection object
 */
export declare const deviceMonitoringLogFullCollection: (conn: IMongodbConnection) => import("mongoose").Collection<IDeviceMonitoringLogRow<DeviceTelemetryType>>;
export declare const prepareDeviceMonitoringLogFullTable: (conn: IMongodbConnection) => Promise<void>;
/**
 * Creates device telemetry model with all methods for fetching, writing, and getting values from database.
 * @param {IMongodbConnection} conn - IMongodbConnection - the connection to the database
 * @returns All model functions
 */
export declare const createDeviceMonitoringLogFullModel: (conn: IMongodbConnection) => IDeviceMonitoringLogModelLatest & IDeviceMonitoringLogModelStats & IDeviceMonitoringLogModelWrite;
//# sourceMappingURL=deviceMonitoringLogFullModel.d.ts.map