"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceHourlyConnectedStatusModel = exports.prepareDeviceHourlyConnectedStatusTable = void 0;
const generator_1 = require("@signageos/lib/dist/Hash/generator");
const collections_1 = require("../../Lib/collections");
const deviceHourlyConnectedStatusCollection = (conn) => conn.connection.collection(collections_1.DeviceCollection.HourlyConnectedStatus);
const prepareDeviceHourlyConnectedStatusTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield deviceHourlyConnectedStatusCollection(conn).createIndex({ uid: 1 }, { name: 'uid', unique: true, background: true });
    yield deviceHourlyConnectedStatusCollection(conn).createIndex({ deviceIdentityHash: 1 }, { name: 'deviceIdentityHash', background: true });
    yield deviceHourlyConnectedStatusCollection(conn).createIndex({ createdAt: 1 }, { name: 'createdAt', background: true, expireAfterSeconds: 8035200 });
    yield deviceHourlyConnectedStatusCollection(conn).createIndex({ deviceIdentityHash: 1, from: 1 }, { name: 'deviceIdentityHash_from', background: true });
    yield deviceHourlyConnectedStatusCollection(conn).createIndex({ deviceIdentityHash: 1, from: 1, to: 1 }, { name: 'deviceIdentityHash_from_to', background: true });
});
exports.prepareDeviceHourlyConnectedStatusTable = prepareDeviceHourlyConnectedStatusTable;
const createDeviceHourlyConnectedStatusModel = (conn) => ({
    create(device, createdAt, from, to, time) {
        return __awaiter(this, void 0, void 0, function* () {
            const newRow = {
                uid: (0, generator_1.generateUniqueHash)(),
                deviceIdentityHash: device.identityHash,
                createdAt,
                from,
                to,
                time,
            };
            yield deviceHourlyConnectedStatusCollection(conn).insertOne(newRow);
        });
    },
    fetchListByDevice(device) {
        const query = deviceHourlyConnectedStatusCollection(conn).find({
            deviceIdentityHash: device.identityHash,
        });
        return query.sort({ from: 1 }).toArray();
    },
    fetchListByDeviceAndFromTo(device, from, to) {
        const query = deviceHourlyConnectedStatusCollection(conn).find({
            deviceIdentityHash: device.identityHash,
            from: {
                $gte: from,
            },
            to: {
                $lte: to, // exception in fetching (normally is used $lt in pair with $gte)
            },
        });
        return query.sort({ from: 1 }).toArray();
    },
    deleteFromBefore(_fromBefore) {
        return __awaiter(this, void 0, void 0, function* () {
            // Not necessary in mongodb to remove old rows, because of expireAfterSeconds index on createdAt
        });
    },
});
exports.createDeviceHourlyConnectedStatusModel = createDeviceHourlyConnectedStatusModel;
//# sourceMappingURL=deviceHourlyConnectedStatusModel.js.map