"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceExportLogModel = exports.prepareDeviceExportLogTable = exports.deviceExportLogCollection = void 0;
const collections_1 = require("../../Lib/collections");
const deviceExportLogCollection = (conn) => {
    return conn.connection.collection(collections_1.DeviceCollection.ExportLog);
};
exports.deviceExportLogCollection = deviceExportLogCollection;
const prepareDeviceExportLogTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.deviceExportLogCollection)(conn).createIndex({ requestId: 1 }, { name: 'requestId', unique: true, background: true });
    yield (0, exports.deviceExportLogCollection)(conn).createIndex({ accountId: 1 }, { name: 'accountId', background: true });
});
exports.prepareDeviceExportLogTable = prepareDeviceExportLogTable;
const createDeviceExportLogModel = (conn) => ({
    fetchListByAccountId(accountId) {
        const filter = {
            accountId: accountId,
        };
        const options = {
            sort: {
                startedAt: -1,
            },
            session: conn.session,
        };
        return (0, exports.deviceExportLogCollection)(conn).find(filter, options).toArray();
    },
    fetchByRequestId(requestId) {
        return (0, exports.deviceExportLogCollection)(conn).findOne({ requestId: requestId }, { session: conn.session });
    },
    create(accountId, requestId, startedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            const newRow = {
                accountId,
                requestId,
                startedAt,
            };
            yield (0, exports.deviceExportLogCollection)(conn).insertOne(newRow, { session: conn.session });
        });
    },
    markSucceeded(requestId, finishedAt, downloadLink) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.deviceExportLogCollection)(conn).updateOne({ requestId: requestId }, {
                $set: {
                    finishedAt: finishedAt,
                    downloadLink: downloadLink,
                },
            }, { session: conn.session });
        });
    },
    markFailed(requestId, finishedAt, errorMessage) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.deviceExportLogCollection)(conn).updateOne({ requestId: requestId }, {
                $set: {
                    finishedAt: finishedAt,
                    errorMessage: errorMessage,
                },
            }, { session: conn.session });
        });
    },
});
exports.createDeviceExportLogModel = createDeviceExportLogModel;
//# sourceMappingURL=deviceExportLogModel.js.map