"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceConfigurationModel = exports.prepareDeviceConfigurationTable = exports.deviceConfigurationCollection = void 0;
const deviceModel_1 = require("../deviceModel");
const collections_1 = require("../../Lib/collections");
const deviceConfigurationCollection = (conn) => conn.connection.collection(collections_1.DeviceCollection.Configuration);
exports.deviceConfigurationCollection = deviceConfigurationCollection;
const prepareDeviceConfigurationTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.deviceConfigurationCollection)(conn).createIndex({ deviceIdentityHash: 1 }, { name: 'deviceIdentityHash', unique: true, background: true });
});
exports.prepareDeviceConfigurationTable = prepareDeviceConfigurationTable;
const mapDeviceConfiguration = (deviceConfiguration, device) => {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s;
    return Object.assign(Object.assign(Object.assign({
        platformUri: (_a = deviceConfiguration === null || deviceConfiguration === void 0 ? void 0 : deviceConfiguration.platformUri) !== null && _a !== void 0 ? _a : null,
        uploadBaseUrl: (_b = deviceConfiguration === null || deviceConfiguration === void 0 ? void 0 : deviceConfiguration.uploadBaseUrl) !== null && _b !== void 0 ? _b : null,
        staticBaseUrl: (_c = deviceConfiguration === null || deviceConfiguration === void 0 ? void 0 : deviceConfiguration.staticBaseUrl) !== null && _c !== void 0 ? _c : null,
        weinreUri: (_d = deviceConfiguration === null || deviceConfiguration === void 0 ? void 0 : deviceConfiguration.weinreUri) !== null && _d !== void 0 ? _d : null,
        extendedManagementUrl: (_e = deviceConfiguration === null || deviceConfiguration === void 0 ? void 0 : deviceConfiguration.extendedManagementUrl) !== null && _e !== void 0 ? _e : null,
        socketDriver: (_f = deviceConfiguration === null || deviceConfiguration === void 0 ? void 0 : deviceConfiguration.socketDriver) !== null && _f !== void 0 ? _f : null,
        lastUsedProtocol: (_g = deviceConfiguration === null || deviceConfiguration === void 0 ? void 0 : deviceConfiguration.lastUsedProtocol) !== null && _g !== void 0 ? _g : null,
        extendedTelemetryEnabledUntil: (_h = deviceConfiguration === null || deviceConfiguration === void 0 ? void 0 : deviceConfiguration.extendedTelemetryEnabledUntil) !== null && _h !== void 0 ? _h : null,
    }, { 
        // TODO device can be remove when all data are migrated from device to deviceConfiguration
        // prettier-ignore
        deviceIdentityHash: deviceConfiguration ?
            deviceConfiguration.deviceIdentityHash :
            device === null || device === void 0 ? void 0 : device.identityHash, createdAt: (_k = (_j = deviceConfiguration === null || deviceConfiguration === void 0 ? void 0 : deviceConfiguration.createdAt) !== null && _j !== void 0 ? _j : device === null || device === void 0 ? void 0 : device.createdAt) !== null && _k !== void 0 ? _k : new Date(), updatedAt: (_m = (_l = deviceConfiguration === null || deviceConfiguration === void 0 ? void 0 : deviceConfiguration.updatedAt) !== null && _l !== void 0 ? _l : device === null || device === void 0 ? void 0 : device.createdAt) !== null && _m !== void 0 ? _m : new Date(), bannedSince: (_p = (_o = deviceConfiguration === null || deviceConfiguration === void 0 ? void 0 : deviceConfiguration.bannedSince) !== null && _o !== void 0 ? _o : device === null || device === void 0 ? void 0 : device.bannedSince) !== null && _p !== void 0 ? _p : null, subscriptionType: (_r = (_q = deviceConfiguration === null || deviceConfiguration === void 0 ? void 0 : deviceConfiguration.subscriptionType) !== null && _q !== void 0 ? _q : device === null || device === void 0 ? void 0 : device.subscriptionType) !== null && _r !== void 0 ? _r : null }), ((deviceConfiguration === null || deviceConfiguration === void 0 ? void 0 : deviceConfiguration.telemetryIntervals) === null
        ? { telemetryIntervals: null }
        : (deviceConfiguration === null || deviceConfiguration === void 0 ? void 0 : deviceConfiguration.telemetryIntervals)
            ? { telemetryIntervals: deviceConfiguration.telemetryIntervals }
            : {})), { offlineActionsLimits: (_s = deviceConfiguration === null || deviceConfiguration === void 0 ? void 0 : deviceConfiguration.offlineActionsLimits) !== null && _s !== void 0 ? _s : null });
};
const createDeviceConfigurationModel = (conn) => {
    /** @deprecated Keep updating device collection for backward compatibility */
    const deviceModel = (0, deviceModel_1.createDeviceModel)(conn, {});
    const getDeviceStrictly = (identityHash) => __awaiter(void 0, void 0, void 0, function* () {
        const device = yield deviceModel.fetchByIdentityHash(identityHash);
        if (!device) {
            throw new Error(`Device not found: ${identityHash}`);
        }
        return device;
    });
    return {
        fetchListByIdentityHashes(deviceIdentityHashes) {
            return __awaiter(this, void 0, void 0, function* () {
                const pipeline = [{ $match: { deviceIdentityHash: { $in: deviceIdentityHashes } } }];
                const deviceConfigurations = yield (0, exports.deviceConfigurationCollection)(conn).aggregate(pipeline).toArray();
                return deviceConfigurations.map((deviceConfiguration) => mapDeviceConfiguration(deviceConfiguration, null));
            });
        },
        fetchByDevice(deviceRow) {
            return __awaiter(this, void 0, void 0, function* () {
                /** @default Only for backward compatibility */
                const device = yield getDeviceStrictly(deviceRow.identityHash);
                const deviceConfiguration = yield (0, exports.deviceConfigurationCollection)(conn).findOne({ deviceIdentityHash: deviceRow.identityHash }, { session: conn.session });
                return deviceConfiguration || device ? mapDeviceConfiguration(deviceConfiguration, device) : null;
            });
        },
        setUpdatedAt(deviceConfigurationRow, updatedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceConfigurationCollection)(conn).updateOne({ deviceIdentityHash: deviceConfigurationRow.deviceIdentityHash }, {
                    $set: {
                        deviceIdentityHash: deviceConfigurationRow.deviceIdentityHash,
                        updatedAt,
                    },
                }, { session: conn.session, upsert: true });
            });
        },
        create(deviceRow, createdAt, values, subscriptionType) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceConfigurationCollection)(conn).insertOne(Object.assign({ deviceIdentityHash: deviceRow.identityHash, createdAt, bannedSince: null, subscriptionType, updatedAt: createdAt }, values), { session: conn.session });
                // Backward compatibility
                const device = yield getDeviceStrictly(deviceRow.identityHash);
                yield deviceModel.changeSubscriptionType(device, subscriptionType);
            });
        },
        update(deviceConfigurationRow, values, updatedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceConfigurationCollection)(conn).updateOne({ deviceIdentityHash: deviceConfigurationRow.deviceIdentityHash }, {
                    $set: Object.assign(Object.assign({ deviceIdentityHash: deviceConfigurationRow.deviceIdentityHash }, values), { updatedAt }),
                }, { session: conn.session, upsert: true });
            });
        },
        setLastUsedProtocol(deviceConfigurationRow, lastUsedProtocol) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceConfigurationCollection)(conn).updateOne({ deviceIdentityHash: deviceConfigurationRow.deviceIdentityHash }, {
                    $set: {
                        deviceIdentityHash: deviceConfigurationRow.deviceIdentityHash,
                        lastUsedProtocol,
                    },
                }, { session: conn.session, upsert: true });
            });
        },
        markBanned(deviceConfigurationRow, bannedSince) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceConfigurationCollection)(conn).updateOne({ deviceIdentityHash: deviceConfigurationRow.deviceIdentityHash }, {
                    $set: {
                        deviceIdentityHash: deviceConfigurationRow.deviceIdentityHash,
                        bannedSince,
                        updatedAt: bannedSince,
                    },
                }, { session: conn.session, upsert: true });
                // Backward compatibility
                const device = yield getDeviceStrictly(deviceConfigurationRow.deviceIdentityHash);
                yield deviceModel.markBanned(device, bannedSince);
            });
        },
        markApproved(deviceConfigurationRow, approvedSince) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceConfigurationCollection)(conn).updateOne({ deviceIdentityHash: deviceConfigurationRow.deviceIdentityHash }, {
                    $set: {
                        deviceIdentityHash: deviceConfigurationRow.deviceIdentityHash,
                        bannedSince: null,
                        updatedAt: approvedSince,
                    },
                }, { session: conn.session, upsert: true });
                // Backward compatibility
                const device = yield getDeviceStrictly(deviceConfigurationRow.deviceIdentityHash);
                yield deviceModel.markApproved(device, approvedSince);
            });
        },
        changeSubscriptionType(deviceConfigurationRow, subscriptionType, updatedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceConfigurationCollection)(conn).updateOne({ deviceIdentityHash: deviceConfigurationRow.deviceIdentityHash }, {
                    $set: {
                        deviceIdentityHash: deviceConfigurationRow.deviceIdentityHash,
                        subscriptionType,
                        updatedAt,
                    },
                }, { session: conn.session, upsert: true });
                // Backward compatibility
                const device = yield getDeviceStrictly(deviceConfigurationRow.deviceIdentityHash);
                yield deviceModel.changeSubscriptionType(device, subscriptionType);
            });
        },
        enableExtendedTelemetry(deviceConfigurationRow, enabledUntil, updatedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceConfigurationCollection)(conn).updateOne({ deviceIdentityHash: deviceConfigurationRow.deviceIdentityHash }, {
                    $set: {
                        deviceIdentityHash: deviceConfigurationRow.deviceIdentityHash,
                        extendedTelemetryEnabledUntil: enabledUntil,
                        updatedAt,
                    },
                }, { session: conn.session, upsert: true });
            });
        },
        disableExtendedTelemetry(deviceConfigurationRow, updatedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceConfigurationCollection)(conn).updateOne({ deviceIdentityHash: deviceConfigurationRow.deviceIdentityHash }, {
                    $unset: {
                        extendedTelemetryEnabledUntil: '',
                    },
                    $set: {
                        updatedAt,
                    },
                }, { session: conn.session, upsert: true });
            });
        },
        setTelemetryIntervals(deviceConfigurationRow, updatedAt, telemetryIntervals) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceConfigurationCollection)(conn).updateOne({ deviceIdentityHash: deviceConfigurationRow.deviceIdentityHash }, {
                    $set: {
                        updatedAt,
                        telemetryIntervals: telemetryIntervals,
                    },
                }, { session: conn.session, upsert: true });
            });
        },
        setOfflineActionsLimits(deviceConfigurationRow, updatedAt, offlineActionsLimits) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceConfigurationCollection)(conn).updateOne({ deviceIdentityHash: deviceConfigurationRow.deviceIdentityHash }, {
                    $set: {
                        updatedAt,
                        offlineActionsLimits: offlineActionsLimits,
                    },
                }, { session: conn.session, upsert: true });
            });
        },
    };
};
exports.createDeviceConfigurationModel = createDeviceConfigurationModel;
//# sourceMappingURL=deviceConfigurationModel.js.map