"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceAuthenticationModel = exports.prepareDeviceAuthenticationTable = void 0;
const collections_1 = require("../../Lib/collections");
const deviceAuthenticationCollection = (conn) => conn.connection.collection(collections_1.DeviceCollection.Authentication);
const prepareDeviceAuthenticationTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield deviceAuthenticationCollection(conn).createIndex({ deviceIdentityHash: 1 }, { name: 'deviceIdentityHash', background: true });
    yield deviceAuthenticationCollection(conn).createIndex({ authHash: 1 }, { name: 'authHash', background: true });
    yield deviceAuthenticationCollection(conn).createIndex({ createdAt: 1 }, { name: 'createdAt', background: true });
});
exports.prepareDeviceAuthenticationTable = prepareDeviceAuthenticationTable;
const createDeviceAuthenticationModel = (conn) => ({
    create(device, authHash, createdAt) {
        return __awaiter(this, void 0, void 0, function* () {
            const newRow = {
                deviceIdentityHash: device.identityHash,
                authHash,
                createdAt,
            };
            yield deviceAuthenticationCollection(conn).insertOne(newRow);
        });
    },
    fetchByDevice(deviceRow) {
        return __awaiter(this, void 0, void 0, function* () {
            return deviceAuthenticationCollection(conn).findOne({ deviceIdentityHash: deviceRow.identityHash }, { sort: { _id: -1 } });
        });
    },
    fetchByAuthHashStartsWith(authHash) {
        return __awaiter(this, void 0, void 0, function* () {
            return deviceAuthenticationCollection(conn).findOne({
                authHash: {
                    $regex: `^${authHash}`,
                },
            }, { sort: { _id: -1 } });
        });
    },
});
exports.createDeviceAuthenticationModel = createDeviceAuthenticationModel;
//# sourceMappingURL=deviceAuthenticationModel.js.map