"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceAppletTestModel = exports.prepareDeviceAppletTestTable = exports.deviceAppletTestCollection = void 0;
const collections_1 = require("../../Lib/collections");
const deviceAppletTestCollection = (conn) => conn.connection.collection(collections_1.DeviceCollection.AppletTest);
exports.deviceAppletTestCollection = deviceAppletTestCollection;
const prepareDeviceAppletTestTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.deviceAppletTestCollection)(conn).createIndex({ uid: 1 }, { name: 'uid', unique: true, background: true });
    yield (0, exports.deviceAppletTestCollection)(conn).createIndex({ deviceIdentityHash: 1 }, { name: 'deviceIdentityHash', background: true });
});
exports.prepareDeviceAppletTestTable = prepareDeviceAppletTestTable;
const createDeviceAppletTestModel = (conn) => ({
    fetchByUid(uid) {
        const filter = {
            uid,
        };
        return (0, exports.deviceAppletTestCollection)(conn).findOne(filter, { session: conn.session });
    },
    fetchLatestByDevice(device) {
        const filter = {
            deviceIdentityHash: device.identityHash,
        };
        return (0, exports.deviceAppletTestCollection)(conn).findOne(filter, { sort: { createdAt: -1 }, session: conn.session });
    },
    fetchLatestByDeviceAndAppletUidAndAppletVersion(device, appletUid, appletVersion) {
        const filter = {
            deviceIdentityHash: device.identityHash,
            appletUid,
            appletVersion,
        };
        return (0, exports.deviceAppletTestCollection)(conn).findOne(filter, { sort: { createdAt: -1 }, session: conn.session });
    },
    create(uid, appletUid, appletVersion, device, tests, createdAt) {
        return __awaiter(this, void 0, void 0, function* () {
            const newRow = {
                uid,
                appletUid,
                appletVersion,
                deviceIdentityHash: device.identityHash,
                createdAt,
                pendingTests: tests,
                failedTests: [],
                successfulTests: [],
            };
            yield (0, exports.deviceAppletTestCollection)(conn).insertOne(newRow, { session: conn.session });
        });
    },
    markFinished(deviceAppletTestRow, finishedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.deviceAppletTestCollection)(conn).updateOne({ uid: deviceAppletTestRow.uid }, {
                $set: {
                    finishedAt,
                },
            }, { session: conn.session });
        });
    },
    markCanceled(deviceAppletTestRow, canceledAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.deviceAppletTestCollection)(conn).updateOne({ uid: deviceAppletTestRow.uid }, {
                $set: {
                    canceledAt,
                },
            }, { session: conn.session });
        });
    },
    markFailed(deviceAppletTestRow, failedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.deviceAppletTestCollection)(conn).updateOne({ uid: deviceAppletTestRow.uid }, {
                $set: {
                    failedAt,
                },
            }, { session: conn.session });
        });
    },
    setTestSucceeded(deviceAppletTestRow, test) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.deviceAppletTestCollection)(conn).updateOne({ uid: deviceAppletTestRow.uid }, {
                $pull: {
                    pendingTests: test,
                },
                $push: {
                    successfulTests: test,
                },
            }, { session: conn.session });
        });
    },
    setTestFailed(deviceAppletTestRow, test) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.deviceAppletTestCollection)(conn).updateOne({ uid: deviceAppletTestRow.uid }, {
                $pull: {
                    pendingTests: test,
                },
                $push: {
                    failedTests: test,
                },
            }, { session: conn.session });
        });
    },
});
exports.createDeviceAppletTestModel = createDeviceAppletTestModel;
//# sourceMappingURL=deviceAppletTestModel.js.map