"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createCompanyNetworkModel = exports.prepareCompanyNetworkTable = exports.companyNetworkCollection = void 0;
const collections_1 = require("../Lib/collections");
const model_1 = require("../Lib/Model/model");
const companyNetworkCollection = (conn) => conn.connection.collection(collections_1.Collection.CompanyNetwork);
exports.companyNetworkCollection = companyNetworkCollection;
const prepareCompanyNetworkTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.companyNetworkCollection)(conn).createIndex('uid', { name: 'uid', unique: true, background: true });
    // This field stays for backwards compatibility.
    // TODO Once all documents are migrated to whiteLabelSettingsUids, this can be removed
    yield (0, exports.companyNetworkCollection)(conn).createIndex('whiteLabelSettingsUid', {
        name: 'whiteLabelSettingsUid',
        background: true,
    });
    yield (0, exports.companyNetworkCollection)(conn).createIndex('whiteLabelSettingsUids', {
        name: 'whiteLabelSettingsUids',
        background: true,
    });
});
exports.prepareCompanyNetworkTable = prepareCompanyNetworkTable;
const createCompanyNetworkModel = (conn) => (Object.assign(Object.assign({}, (0, model_1.createModel)({
    conn,
    collection: collections_1.Collection.CompanyNetwork,
})), { fetchByWhiteLabelSettingsUid(whiteLabelSettingsUid) {
        return __awaiter(this, void 0, void 0, function* () {
            const companyNetwork = yield (0, exports.companyNetworkCollection)(conn).findOne({
                $or: [{ whiteLabelSettingsUids: whiteLabelSettingsUid }, { whiteLabelSettingsUid }],
            }, { session: conn.session });
            return companyNetwork ? mapCompanyNetwork(companyNetwork) : null;
        });
    },
    fetchAll() {
        return __awaiter(this, void 0, void 0, function* () {
            const companyNetworks = yield (0, exports.companyNetworkCollection)(conn).find().sort({ createdAt: -1 }).toArray();
            return companyNetworks.map(mapCompanyNetwork);
        });
    },
    assignWhiteLabelSettings({ companyNetwork, whiteLabelSettings, updatedAt }) {
        return __awaiter(this, void 0, void 0, function* () {
            // we're pulling some values from it to modify them so we need to make sure we have the latest version
            const latestCompanyNetwork = yield this.fetchByUid(companyNetwork.uid);
            if (!latestCompanyNetwork) {
                throw new Error(`Company network with uid ${companyNetwork.uid} not found`);
            }
            const wlsSet = [whiteLabelSettings.uid];
            const setQuery = { updatedAt };
            // This migrates old documents that had whiteLabelSettingsUid to whiteLabelSettingsUids
            // TODO Once all documents are migrated to whiteLabelSettingsUids, this can be removed
            if (latestCompanyNetwork.whiteLabelSettingsUid) {
                wlsSet.push(latestCompanyNetwork.whiteLabelSettingsUid);
            }
            else {
                setQuery.whiteLabelSettingsUid = whiteLabelSettings.uid;
            }
            yield (0, exports.companyNetworkCollection)(conn).updateOne({ uid: latestCompanyNetwork.uid }, {
                $set: setQuery,
                $addToSet: {
                    whiteLabelSettingsUids: { $each: wlsSet },
                },
            }, { session: conn.session });
        });
    },
    unassignWhiteLabelSettings({ companyNetwork, whiteLabelSettings, updatedAt }) {
        return __awaiter(this, void 0, void 0, function* () {
            // we're pulling some values from it to modify them so we need to make sure we have the latest version
            const latestCompanyNetwork = yield this.fetchByUid(companyNetwork.uid);
            if (!latestCompanyNetwork) {
                throw new Error(`Company network with uid ${companyNetwork.uid} not found`);
            }
            const newWlsUids = latestCompanyNetwork.whiteLabelSettingsUids.filter((wlsUid) => wlsUid !== whiteLabelSettings.uid);
            const setQuery = { updatedAt };
            const unsetQuery = {};
            // TODO once all documents are migrated to whiteLabelSettingsUids, this can be removed
            if (latestCompanyNetwork.whiteLabelSettingsUid === whiteLabelSettings.uid) {
                if (newWlsUids.length > 0) {
                    setQuery.whiteLabelSettingsUid = newWlsUids[0];
                }
                else {
                    unsetQuery.whiteLabelSettingsUid = '';
                }
            }
            yield (0, exports.companyNetworkCollection)(conn).updateOne({ uid: latestCompanyNetwork.uid }, Object.assign({ $set: setQuery, $pull: { whiteLabelSettingsUids: whiteLabelSettings.uid } }, (Object.keys(unsetQuery).length > 0 && { $unset: unsetQuery })), { session: conn.session });
        });
    },
    fetchBrandsByCompanyNetworks({ companyNetworkUids, }) {
        return __awaiter(this, void 0, void 0, function* () {
            const companyNetworks = yield this.fetchListByUids(companyNetworkUids);
            const brandsSet = new Set();
            for (const companyNetwork of companyNetworks) {
                const deviceFilter = companyNetwork.deviceFilter;
                if (!(deviceFilter === null || deviceFilter === void 0 ? void 0 : deviceFilter.brands) || deviceFilter.brands.length === 0) {
                    return []; // all brands are allowed
                }
                deviceFilter.brands.forEach((brand) => brandsSet.add(brand));
            }
            return [...brandsSet];
        });
    } }));
exports.createCompanyNetworkModel = createCompanyNetworkModel;
// TODO Once all documents are migrated to whiteLabelSettingsUids, this can be removed
function mapCompanyNetwork(companyNetwork) {
    var _a;
    const legacyWlsUidAsArray = companyNetwork.whiteLabelSettingsUid ? [companyNetwork.whiteLabelSettingsUid] : [];
    const wlsUids = (_a = companyNetwork.whiteLabelSettingsUids) !== null && _a !== void 0 ? _a : [];
    return Object.assign(Object.assign({}, companyNetwork), { whiteLabelSettingsUids: wlsUids.length > 0 ? wlsUids : legacyWlsUidAsArray });
}
//# sourceMappingURL=companyNetworkModel.js.map