"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createApplicationVersionModel = exports.prepareApplicationVersionTable = exports.applicationVersionCollection = void 0;
const generator_1 = require("@signageos/lib/dist/Hash/generator");
const versions_1 = require("../../../Helpers/versions");
const collections_1 = require("../../Lib/collections");
const paginationTypes_1 = require("../../../Lib/Pagination/paginationTypes");
const applicationVersionCollection = (conn) => conn.connection.collection(collections_1.Collection.ApplicationVersion);
exports.applicationVersionCollection = applicationVersionCollection;
const prepareApplicationVersionTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.applicationVersionCollection)(conn).createIndex('uid', { name: 'uid', unique: true, background: true });
    yield (0, exports.applicationVersionCollection)(conn).createIndex('application', { name: 'application', background: true });
    yield (0, exports.applicationVersionCollection)(conn).createIndex('version', { name: 'version', background: true });
    yield (0, exports.applicationVersionCollection)(conn).createIndex('versionComparable', { name: 'versionComparable', background: true });
    yield (0, exports.applicationVersionCollection)(conn).createIndex('createdAt', { name: 'createdAt', background: true });
});
exports.prepareApplicationVersionTable = prepareApplicationVersionTable;
const createApplicationVersionModel = (conn) => ({
    create(application, frontDisplayVersion, version, supportedFirmwareTypes, createdAt) {
        return __awaiter(this, void 0, void 0, function* () {
            const newDoc = {
                uid: (0, generator_1.generateUniqueHash)(),
                version,
                frontDisplayVersion: frontDisplayVersion.version,
                application: application.type,
                createdAt,
                testSuites: [],
                versionComparable: (0, versions_1.numberize)(version),
            };
            if (supportedFirmwareTypes !== undefined) {
                newDoc.supportedFirmwareTypes = supportedFirmwareTypes;
            }
            yield (0, exports.applicationVersionCollection)(conn).insertOne(newDoc, { session: conn.session });
        });
    },
    fetchByUid(uid) {
        return (0, exports.applicationVersionCollection)(conn).findOne({ uid }, { session: conn.session });
    },
    fetchByApplicationAndVersion(application, version) {
        return (0, exports.applicationVersionCollection)(conn).findOne({
            application: application.type,
            version,
        }, { session: conn.session });
    },
    fetchListByApplication(application, onlyPublished) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.fetchListByFilter({ applicationType: application, onlyPublished });
        });
    },
    fetchListByUids(uids) {
        return (0, exports.applicationVersionCollection)(conn)
            .find({ uid: { $in: uids } }, { session: conn.session })
            .sort({ _id: 1 })
            .toArray();
    },
    fetchAll(onlyPublished) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.fetchListByFilter({ onlyPublished });
        });
    },
    fetchLatestByApplication(application, onlyPublished, onlyReleased) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.fetchLatestByFilter({ applicationType: application, onlyPublished, onlyReleased });
        });
    },
    fetchListByFilter(filter, sort) {
        return __awaiter(this, void 0, void 0, function* () {
            const mongoFilter = convertPropertyFilterToMongoFilter(filter);
            const aggregate = [{ $match: mongoFilter }];
            if (typeof sort !== 'undefined') {
                aggregate.push({ $sort: { [sort.field]: sort.order === paginationTypes_1.SortOrder.DESC ? -1 : 1 } });
            }
            if (filter.limit) {
                aggregate.push({ $limit: filter.limit });
            }
            return (0, exports.applicationVersionCollection)(conn).aggregate(aggregate, { session: conn.session }).toArray();
        });
    },
    fetchLatestByFilter(filter) {
        return __awaiter(this, void 0, void 0, function* () {
            const mongoFilter = convertPropertyFilterToMongoFilter(filter);
            return yield (0, exports.applicationVersionCollection)(conn).findOne(mongoFilter, {
                session: conn.session,
                sort: { versionComparable: -1 },
                limit: 1,
            });
        });
    },
    markAsPublished(applicationVersionRow, publishedSince) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.applicationVersionCollection)(conn).updateOne({ uid: applicationVersionRow.uid }, { $set: { publishedSince } }, { session: conn.session });
        });
    },
    markAsNotPublished(applicationVersionRow) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.applicationVersionCollection)(conn).updateOne({ uid: applicationVersionRow.uid }, { $unset: { publishedSince: '' } }, { session: conn.session });
        });
    },
    markAsDeprecated(applicationVersionRow, deprecatedSince) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.applicationVersionCollection)(conn).updateOne({ uid: applicationVersionRow.uid }, { $set: { deprecatedSince } }, { session: conn.session });
        });
    },
    markAsNotDeprecated(applicationVersionRow) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.applicationVersionCollection)(conn).updateOne({ uid: applicationVersionRow.uid }, { $unset: { deprecatedSince: '' } }, { session: conn.session });
        });
    },
    updateDescription(applicationVersionRow, description) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.applicationVersionCollection)(conn).updateOne({ uid: applicationVersionRow.uid }, { $set: { description } }, { session: conn.session });
        });
    },
    setTestSuite(applicationVersionRow, suiteGroup, tests) {
        return __awaiter(this, void 0, void 0, function* () {
            // remove the previous testSuite with the same name
            yield (0, exports.applicationVersionCollection)(conn).updateOne({ uid: applicationVersionRow.uid }, { $pull: { testSuites: { suiteType: suiteGroup.suiteType } } }, { session: conn.session });
            yield (0, exports.applicationVersionCollection)(conn).updateOne({ uid: applicationVersionRow.uid }, { $addToSet: { testSuites: Object.assign(Object.assign({}, suiteGroup), tests) } }, { session: conn.session });
        });
    },
    setTestSuitePassed(applicationVersionRow, suiteGroup, passedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.applicationVersionCollection)(conn).updateOne({
                uid: applicationVersionRow.uid,
                'testSuites.suiteType': suiteGroup.suiteType,
            }, {
                $set: {
                    'testSuites.$.passedAt': passedAt,
                },
                $unset: {
                    'testSuites.$.failedAt': '',
                },
            }, { session: conn.session });
        });
    },
    setTestSuiteFailed(applicationVersionRow, suiteGroup, failed) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.applicationVersionCollection)(conn).updateOne({
                uid: applicationVersionRow.uid,
                'testSuites.suiteType': suiteGroup.suiteType,
            }, {
                $set: {
                    'testSuites.$.failedAt': failed,
                },
                $unset: {
                    'testSuites.$.passedAt': '',
                },
            }, { session: conn.session });
        });
    },
    addTestPassed(applicationVersionRow, suiteGroup, identification) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.applicationVersionCollection)(conn).updateOne({
                uid: applicationVersionRow.uid,
                'testSuites.suiteType': suiteGroup.suiteType,
            }, {
                $addToSet: {
                    'testSuites.$.passedTests': identification,
                },
                $pull: {
                    'testSuites.$.pendingTests': identification,
                    'testSuites.$.failedTests': identification,
                },
            }, { session: conn.session });
        });
    },
    addTestFailed(applicationVersionRow, suiteGroup, identification) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.applicationVersionCollection)(conn).updateOne({
                uid: applicationVersionRow.uid,
                'testSuites.suiteType': suiteGroup.suiteType,
            }, {
                $addToSet: {
                    'testSuites.$.failedTests': identification,
                },
                $pull: {
                    'testSuites.$.pendingTests': identification,
                    'testSuites.$.passedTests': identification,
                },
            }, { session: conn.session });
        });
    },
});
exports.createApplicationVersionModel = createApplicationVersionModel;
function convertPropertyFilterToMongoFilter(filter) {
    var _a;
    const mongoFilter = {};
    if (filter.applicationType !== undefined) {
        mongoFilter.application = filter.applicationType;
    }
    if (filter.onlyPublished) {
        mongoFilter.publishedSince = { $exists: true };
    }
    if (filter.onlyReleased) {
        mongoFilter.$and = [{ version: { $not: RegExp(/-/, 'gi') } }]; // must not contain "-" character
    }
    if (filter.supportedFirmwareType !== undefined) {
        mongoFilter.supportedFirmwareTypes = filter.supportedFirmwareType === null ? { $exists: false } : filter.supportedFirmwareType;
    }
    if (filter.search) {
        mongoFilter.$and = [...((_a = mongoFilter.$and) !== null && _a !== void 0 ? _a : []), { version: new RegExp(`${filter.search}`, 'i') }];
    }
    return mongoFilter;
}
//# sourceMappingURL=applicationVersionModel.js.map