"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPipelineBaseByOrganizationsAndFilter = void 0;
const ApplicationVersionBuildRequest_1 = require("@signageos/common-types/dist/Application/Version/ApplicationVersionBuildRequest");
const createPipelineBaseByOrganizationsAndFilter = (filter) => {
    let pipeline = [];
    pipeline.push({
        $match: Object.assign((filter === null || filter === void 0 ? void 0 : filter.organizations) ? { 'bundledApplet.organizationUid': { $in: filter.organizations.map((org) => org.uid) } } : {}, (filter === null || filter === void 0 ? void 0 : filter.appletUid) ? { 'bundledApplet.uid': filter.appletUid } : {}, (filter === null || filter === void 0 ? void 0 : filter.appletVersion) ? { 'bundledApplet.version': filter.appletVersion } : {}, (filter === null || filter === void 0 ? void 0 : filter.applicationType) ? { 'application.name': filter.applicationType } : {}, (filter === null || filter === void 0 ? void 0 : filter.builtSince) ? { builtSince: { $gte: filter.builtSince } } : {}),
    });
    if ((filter === null || filter === void 0 ? void 0 : filter.includeByStatus) && filter.includeByStatus.length > 0) {
        pipeline.push({
            $match: {
                $or: [
                    filter.includeByStatus.includes(ApplicationVersionBuildRequest_1.ApplicationVersionBuildRequestStatus.BUILDING) ? { failedAt: null, builtSince: null } : {},
                    filter.includeByStatus.includes(ApplicationVersionBuildRequest_1.ApplicationVersionBuildRequestStatus.COMPLETED) ? { builtSince: { $ne: null } } : {},
                    filter.includeByStatus.includes(ApplicationVersionBuildRequest_1.ApplicationVersionBuildRequestStatus.FAILED) ? { failedAt: { $ne: null } } : {},
                ].filter((obj) => Object.keys(obj).length !== 0),
            },
        });
    }
    return pipeline;
};
exports.createPipelineBaseByOrganizationsAndFilter = createPipelineBaseByOrganizationsAndFilter;
//# sourceMappingURL=applicationVersionBuildRequestModelUtils.js.map