"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createApplicationVersionBuildRequestModel = exports.prepareApplicationVersionBuildRequestTable = exports.applicationVersionBuildRequestCollection = void 0;
const collections_1 = require("../../Lib/collections");
const escape_1 = require("@signageos/lib/dist/MongoDB/escape");
const applicationVersionBuildRequestModelUtils_1 = require("./applicationVersionBuildRequestModelUtils");
const applicationVersionBuildRequestCollection = (conn) => conn.connection.collection(collections_1.Collection.ApplicationVersionBuildRequest);
exports.applicationVersionBuildRequestCollection = applicationVersionBuildRequestCollection;
const prepareApplicationVersionBuildRequestTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.applicationVersionBuildRequestCollection)(conn).createIndex({ requestUid: 1 }, { name: 'requestUid', unique: true, background: true });
    yield (0, exports.applicationVersionBuildRequestCollection)(conn).createIndex({ 'application.name': 1, 'application.version': 1, 'bundledApplet.uid': 1, 'bundledApplet.version': 1 }, { name: 'app_and_applet_type_uid_version', background: true });
});
exports.prepareApplicationVersionBuildRequestTable = prepareApplicationVersionBuildRequestTable;
function mapDocToEntity(doc) {
    if (!doc) {
        return null;
    }
    const { _id } = doc, cleanDoc = __rest(doc, ["_id"]);
    return Object.assign(Object.assign({}, cleanDoc), { bundledApplet: Object.assign(Object.assign({}, cleanDoc.bundledApplet), { config: (0, escape_1.unescapeObject)(cleanDoc.bundledApplet.config) }) });
}
function mapEntityToDoc(entity) {
    return Object.assign(Object.assign({}, entity), { bundledApplet: Object.assign(Object.assign({}, entity.bundledApplet), { config: (0, escape_1.escapeObject)(entity.bundledApplet.config) }) });
}
const createApplicationVersionBuildRequestModel = (conn) => ({
    fetchByRequestUid(requestUid) {
        return __awaiter(this, void 0, void 0, function* () {
            const doc = yield (0, exports.applicationVersionBuildRequestCollection)(conn).findOne({ requestUid }, { session: conn.session });
            return mapDocToEntity(doc);
        });
    },
    create(applicationVersionBuildRequest) {
        return __awaiter(this, void 0, void 0, function* () {
            const applicationVersionBuildRequestDoc = mapEntityToDoc(applicationVersionBuildRequest);
            // backward compatibility hack when createdAt was not set
            applicationVersionBuildRequestDoc.createdAt = applicationVersionBuildRequestDoc.createdAt || new Date();
            yield (0, exports.applicationVersionBuildRequestCollection)(conn).insertOne(applicationVersionBuildRequestDoc, { session: conn.session });
        });
    },
    fetchAll() {
        return __awaiter(this, void 0, void 0, function* () {
            const docs = yield (0, exports.applicationVersionBuildRequestCollection)(conn)
                .find({}, { session: conn.session })
                .toArray();
            return docs.map(mapDocToEntity);
        });
    },
    fetchAllByApplicationType(applicationType, version, appletUid, appletVersion, applicationSignature, applicationFlavour) {
        return __awaiter(this, void 0, void 0, function* () {
            const query = {
                'application.name': applicationType,
                'application.version': version,
                'bundledApplet.uid': appletUid,
                'bundledApplet.version': appletVersion,
                'application.signature': applicationSignature ? applicationSignature : null,
                'application.flavour': applicationFlavour ? applicationFlavour : null,
            };
            const docs = yield (0, exports.applicationVersionBuildRequestCollection)(conn)
                .find(query, { session: conn.session })
                .sort({ createdAt: -1 })
                .toArray();
            return docs.map(mapDocToEntity);
        });
    },
    fetchLastByApplicationType(applicationType, version, appletUid, appletVersion, applicationSignature, applicationFlavour) {
        return __awaiter(this, void 0, void 0, function* () {
            const query = {
                'application.name': applicationType,
                'application.version': version,
                'bundledApplet.uid': appletUid,
                'bundledApplet.version': appletVersion,
                'application.signature': applicationSignature ? applicationSignature : null,
                'application.flavour': applicationFlavour ? applicationFlavour : null,
            };
            const doc = yield (0, exports.applicationVersionBuildRequestCollection)(conn)
                .find(query, { session: conn.session })
                .sort({ createdAt: -1 })
                .limit(1)
                .next();
            return mapDocToEntity(doc);
        });
    },
    markBuildSucceeded(requestUid, builtSince, buildUrl, directBuildUrl) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.applicationVersionBuildRequestCollection)(conn).updateOne({ requestUid }, { $set: { builtSince, buildUrl, directBuildUrl } }, { session: conn.session });
        });
    },
    markBuildFailed(requestUid, failedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.applicationVersionBuildRequestCollection)(conn).updateOne({ requestUid }, { $set: { failedAt } }, { session: conn.session });
        });
    },
    fetchList(args) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const { filter, sorting, pagination } = args;
            const pipeline = filter ? (0, applicationVersionBuildRequestModelUtils_1.createPipelineBaseByOrganizationsAndFilter)(filter) : [];
            pipeline.push({
                $sort: Object.assign({}, (sorting ? {
                    [sorting.field]: sorting.order === 'ascending' ? 1 : -1,
                } : {
                    'createdAt': -1,
                })),
            });
            if (pagination) {
                pipeline.push({
                    $skip: (_a = pagination.offset) !== null && _a !== void 0 ? _a : 0,
                });
                if (pagination.limit) {
                    pipeline.push({
                        $limit: pagination.limit,
                    });
                }
            }
            ;
            const docs = yield (0, exports.applicationVersionBuildRequestCollection)(conn)
                .aggregate(pipeline, { session: conn.session })
                .toArray();
            return docs.map(mapDocToEntity);
        });
    },
    count(filter) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            let pipeline = filter ? (0, applicationVersionBuildRequestModelUtils_1.createPipelineBaseByOrganizationsAndFilter)(filter) : [];
            pipeline = [...pipeline, { $count: 'count' }];
            const [result] = yield (0, exports.applicationVersionBuildRequestCollection)(conn)
                .aggregate(pipeline, { session: conn.session })
                .toArray();
            return (_a = result === null || result === void 0 ? void 0 : result.count) !== null && _a !== void 0 ? _a : 0;
        });
    },
    fetchLatestByBundledApplet(appletUid, sortField) {
        return __awaiter(this, void 0, void 0, function* () {
            const pipeline = [];
            pipeline.push(...[
                {
                    $match: {
                        'bundledApplet.uid': appletUid,
                        builtSince: { $ne: null },
                    },
                },
                {
                    $sort: Object.assign(Object.assign({ 'application.name': 1 }, (sortField === 'bundledApplet.version' ? {
                        'bundledApplet.version': -1,
                    } : {})), { builtSince: -1 }),
                },
                {
                    $group: {
                        _id: '$application.name',
                        latest: { $first: '$$ROOT' },
                    },
                },
                {
                    $replaceRoot: {
                        newRoot: '$latest',
                    },
                },
            ]);
            const docs = yield (0, exports.applicationVersionBuildRequestCollection)(conn)
                .aggregate(pipeline, { session: conn.session })
                .toArray();
            return docs.map(mapDocToEntity);
        });
    },
    countUniqueApplicationNames(filter) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            let pipeline = filter ? (0, applicationVersionBuildRequestModelUtils_1.createPipelineBaseByOrganizationsAndFilter)(filter) : [];
            pipeline = [
                ...pipeline,
                { $group: { _id: '$application.name' } },
                { $count: 'count' },
            ];
            const [result] = yield (0, exports.applicationVersionBuildRequestCollection)(conn)
                .aggregate(pipeline, { session: conn.session })
                .toArray();
            return (_a = result === null || result === void 0 ? void 0 : result.count) !== null && _a !== void 0 ? _a : 0;
        });
    },
});
exports.createApplicationVersionBuildRequestModel = createApplicationVersionBuildRequestModel;
//# sourceMappingURL=applicationVersionBuildRequestModel.js.map