"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPipelineSorterFromPropertySorter = exports.createAlertRuleModel = exports.prepareAlertRuleTable = exports.alertRuleCollection = void 0;
const escape_1 = require("@signageos/lib/dist/MongoDB/escape");
const collections_1 = require("../Lib/collections");
const lodash_1 = require("lodash");
const alertRuleCollection = (conn) => conn.connection.collection(collections_1.Collection.AlertRule);
exports.alertRuleCollection = alertRuleCollection;
const prepareAlertRuleTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.alertRuleCollection)(conn).createIndex({ alertRuleUid: 1 }, { name: 'uid', unique: true, background: true });
    yield (0, exports.alertRuleCollection)(conn).createIndex({ alertType: 1 }, { name: 'alertType', background: true });
    yield (0, exports.alertRuleCollection)(conn).createIndex({ companyUid: 1 }, { name: 'companyUid', background: true });
    yield (0, exports.alertRuleCollection)(conn).createIndex({ name: 1 }, { name: 'name', background: true });
    yield (0, exports.alertRuleCollection)(conn).createIndex({ organizationUids: 1 }, { name: 'organizationUids_multi', background: true });
    yield (0, exports.alertRuleCollection)(conn).createIndex({ createdAt: -1 }, { name: 'createdAt', background: true });
    yield (0, exports.alertRuleCollection)(conn).createIndex({ archivedAt: 1 }, { name: 'archivedAt', background: true });
    yield (0, exports.alertRuleCollection)(conn).createIndex({ pausedAt: 1 }, { name: 'pausedAt', background: true });
});
exports.prepareAlertRuleTable = prepareAlertRuleTable;
const getStatusFilter = (status) => {
    return [
        (status === null || status === void 0 ? void 0 : status.includeActive) !== undefined && status.includeActive ? { archivedAt: null, pausedAt: null } : {},
        (status === null || status === void 0 ? void 0 : status.includePaused) !== undefined && status.includePaused ? { pausedAt: { $ne: null }, archivedAt: null } : {},
        (status === null || status === void 0 ? void 0 : status.includeArchived) !== undefined && status.includeArchived ? { archivedAt: { $ne: null } } : {},
    ].filter((obj) => Object.keys(obj).length !== 0);
};
const createAlertRuleModel = (conn) => {
    const appendHistoryItem = (values, updatedAt, originator) => ({
        $push: { history: { values, updatedAt, originator } },
    });
    const updateAlertRule = (alertRuleRow, update) => (0, exports.alertRuleCollection)(conn).updateOne({ alertRuleUid: alertRuleRow.alertRuleUid }, update, { session: conn.session });
    const updateNotificationOptions = (alertRuleRow, notificationOptions, updatedAt, originator) => __awaiter(void 0, void 0, void 0, function* () {
        const updateObject = {};
        Object.keys(notificationOptions).forEach((key) => {
            updateObject[`notificationOptions.${key}`] = notificationOptions[key];
        });
        yield updateAlertRule(alertRuleRow, Object.assign({ $set: updateObject }, appendHistoryItem({ notificationOptions }, updatedAt, originator)));
    });
    return {
        fetchByUid(alertRuleUid) {
            return (0, exports.alertRuleCollection)(conn).findOne({ alertRuleUid }, { session: conn.session });
        },
        fetchListByOptions(options) {
            var _a, _b, _c;
            let pipeline = [];
            if (options.filter) {
                const { companyUid, organizations, alertTypes, name, isArchived, isPaused } = options.filter;
                pipeline.push({
                    $match: Object.assign(companyUid ? { companyUid } : {}, organizations ? { organizationUids: { $in: organizations.map((org) => org.uid) } } : {}, alertTypes ? { alertType: { $in: alertTypes } } : {}, name ? { name: { $regex: (0, lodash_1.escapeRegExp)(name), $options: 'i' } } : {}, isArchived ? { archivedAt: { $ne: null } } : {}, isPaused ? { pausedAt: { $ne: null } } : {}),
                });
            }
            if (typeof options.sorter !== 'undefined') {
                createPipelineSorterFromPropertySorter(pipeline, options.sorter);
            }
            else {
                pipeline.push({ $sort: { createdAt: -1 } });
            }
            if ((_a = options.filter) === null || _a === void 0 ? void 0 : _a.createdUntil) {
                pipeline.push({ $match: { createdAt: { $lt: options.filter.createdUntil } } });
            }
            if ((_b = options.pagination) === null || _b === void 0 ? void 0 : _b.offset) {
                pipeline.push({ $skip: options.pagination.offset });
            }
            if ((_c = options.pagination) === null || _c === void 0 ? void 0 : _c.limit) {
                pipeline.push({ $limit: options.pagination.limit });
            }
            return (0, exports.alertRuleCollection)(conn).aggregate(pipeline, { session: conn.session }).toArray();
        },
        fetchListByCompanyUidsAndOptions(companyUids, options, status) {
            var _a, _b, _c;
            let pipeline = [];
            const filterStatus = getStatusFilter(status);
            if (options.filter) {
                const { organizations, alertTypes, name, isArchived, isPaused } = options.filter;
                pipeline.push({
                    $match: Object.assign({ companyUid: { $in: companyUids } }, organizations
                        ? {
                            organizationUids: { $ne: null, $exists: true },
                            $expr: {
                                $setIsSubset: ['$organizationUids', organizations.map((org) => org.uid)],
                            },
                        }
                        : {}, alertTypes ? { alertType: { $in: alertTypes } } : {}, name ? { name: { $regex: (0, lodash_1.escapeRegExp)(name), $options: 'i' } } : {}, typeof status === 'undefined' && typeof isArchived !== 'undefined'
                        ? isArchived
                            ? { archivedAt: { $ne: null } }
                            : { archivedAt: null }
                        : {}, typeof status === 'undefined' && typeof isPaused !== 'undefined'
                        ? isPaused
                            ? { pausedAt: { $ne: null } }
                            : { pausedAt: null }
                        : {}),
                });
            }
            if (filterStatus.length > 0) {
                pipeline.push({ $match: { $or: filterStatus } });
            }
            if (typeof options.sorter !== 'undefined') {
                createPipelineSorterFromPropertySorter(pipeline, options.sorter);
            }
            else {
                pipeline.push({ $sort: { createdAt: -1 } });
            }
            if ((_a = options.filter) === null || _a === void 0 ? void 0 : _a.createdUntil) {
                pipeline.push({ $match: { createdAt: { $lt: options.filter.createdUntil } } });
            }
            if ((_b = options.pagination) === null || _b === void 0 ? void 0 : _b.offset) {
                pipeline.push({ $skip: options.pagination.offset });
            }
            if ((_c = options.pagination) === null || _c === void 0 ? void 0 : _c.limit) {
                pipeline.push({ $limit: options.pagination.limit });
            }
            return (0, exports.alertRuleCollection)(conn).aggregate(pipeline, { session: conn.session }).toArray();
        },
        fetchActiveCursorExcludedUids(excludeAlertRuleUids) {
            return __awaiter(this, void 0, void 0, function* () {
                return (0, exports.alertRuleCollection)(conn).find({ alertRuleUid: { $nin: excludeAlertRuleUids } }, { session: conn.session });
            });
        },
        create(alertRuleUid, name, companyUid, createdAt, originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.alertRuleCollection)(conn).insertOne({
                    alertRuleUid,
                    name,
                    companyUid,
                    createdAt,
                    history: [{ values: { name }, updatedAt: createdAt, originator }],
                    archivedAt: null,
                    pausedAt: null,
                }, { session: conn.session });
            });
        },
        update(alertRuleRow, values, updatedAt, originator) {
            return __awaiter(this, void 0, void 0, function* () {
                const escapedValues = (0, escape_1.escapeObject)((0, lodash_1.omit)(values, 'notificationOptions'));
                yield updateAlertRule(alertRuleRow, Object.assign({ $set: escapedValues }, appendHistoryItem(escapedValues, updatedAt, originator)));
                if (values.notificationOptions) {
                    yield updateNotificationOptions(alertRuleRow, values.notificationOptions, updatedAt, originator);
                }
            });
        },
        archive(alertRuleRow, archivedAt, originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlertRule(alertRuleRow, Object.assign({ $set: { archivedAt } }, appendHistoryItem({ archivedAt }, archivedAt, originator)));
            });
        },
        pause(alertRuleRow, pausedAt, originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlertRule(alertRuleRow, Object.assign({ $set: { pausedAt } }, appendHistoryItem({ pausedAt }, pausedAt, originator)));
            });
        },
        unpause(alertRuleRow, unpausedAt, originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlertRule(alertRuleRow, Object.assign({ $set: { pausedAt: null } }, appendHistoryItem({ pausedAt: null }, unpausedAt, originator)));
            });
        },
        countByCompanyUidsAndOptions(companyUids, options, status) {
            var _a;
            return __awaiter(this, void 0, void 0, function* () {
                let pipeline = [];
                const filterStatus = getStatusFilter(status);
                if (options.filter) {
                    const { organizations, alertTypes, name, isArchived, isPaused } = options.filter;
                    pipeline.push({
                        $match: Object.assign({ companyUid: { $in: companyUids } }, organizations
                            ? {
                                organizationUids: { $ne: null, $exists: true },
                                $expr: {
                                    $setIsSubset: ['$organizationUids', organizations.map((org) => org.uid)],
                                },
                            }
                            : {}, alertTypes ? { alertType: { $in: alertTypes } } : {}, name ? { name: { $regex: (0, lodash_1.escapeRegExp)(name), $options: 'i' } } : {}, typeof status === 'undefined' && typeof isArchived !== 'undefined'
                            ? isArchived
                                ? { archivedAt: { $ne: null } }
                                : { archivedAt: null }
                            : {}, typeof status === 'undefined' && typeof isPaused !== 'undefined'
                            ? isPaused
                                ? { pausedAt: { $ne: null } }
                                : { pausedAt: null }
                            : {}),
                    });
                }
                else {
                    pipeline.push({
                        $match: Object.assign({ companyUid: { $in: companyUids } }, typeof status === 'undefined' ? { archivedAt: null } : {}, typeof status === 'undefined'
                            ? {
                                pausedAt: null,
                            }
                            : {}),
                    });
                }
                if (filterStatus.length > 0) {
                    pipeline.push({ $match: { $or: filterStatus } });
                }
                pipeline = [...pipeline, { $count: 'count' }];
                const [result] = yield (0, exports.alertRuleCollection)(conn).aggregate(pipeline, { session: conn.session }).toArray();
                return (_a = result === null || result === void 0 ? void 0 : result.count) !== null && _a !== void 0 ? _a : 0;
            });
        },
    };
};
exports.createAlertRuleModel = createAlertRuleModel;
function createPipelineSorterFromPropertySorter(pipeline, propertySorter) {
    const sortDirection = propertySorter.direction === 'descending' ? -1 : 1;
    switch (propertySorter.field) {
        case 'name':
            pipeline.push({ $sort: { name: sortDirection } });
            break;
        case 'alertType':
            pipeline.push({ $sort: { alertType: sortDirection } });
            break;
        case 'createdAt':
            pipeline.push({ $sort: { createdAt: sortDirection } });
            break;
        default:
            throw new Error('Unknown property to sort by.');
    }
}
exports.createPipelineSorterFromPropertySorter = createPipelineSorterFromPropertySorter;
//# sourceMappingURL=alertRuleModel.js.map