"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAccountSettingsModel = exports.prepareAccountSettingsTable = void 0;
const accountModel_1 = require("./accountModel");
const collections_1 = require("../Lib/collections");
const accountSettingsCollection = (conn) => conn.connection.collection(collections_1.Collection.AccountSettings);
const prepareAccountSettingsTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield accountSettingsCollection(conn).createIndex('accountId', { name: 'accountId', unique: true, background: true });
    yield accountSettingsCollection(conn).createIndex('apiSecurityTokens.id', { name: 'apiSecurityTokens_id', background: true });
});
exports.prepareAccountSettingsTable = prepareAccountSettingsTable;
const createAccountSettingsModel = (conn) => ({
    create(accountId) {
        return __awaiter(this, void 0, void 0, function* () {
            const accountModel = (0, accountModel_1.createAccountModel)(conn);
            const account = yield accountModel.fetchById(accountId);
            if (!account) {
                throw new Error('Cannot create account settings for non-existing account id');
            }
            const doc = {
                accountId,
                apiSecurityTokens: [],
                email: {
                    notificationAlertLevels: ['info', 'warning', 'error'],
                    isSubscribedToNewsletter: true,
                },
            };
            yield accountSettingsCollection(conn).insertOne(doc, { session: conn.session });
        });
    },
    fetchByAccount(account) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield accountSettingsCollection(conn).findOne({ accountId: account.id }, { session: conn.session });
        });
    },
    fetchByApiSecurityTokenId(id) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield accountSettingsCollection(conn).findOne({ 'apiSecurityTokens.id': id }, { session: conn.session });
        });
    },
    updateTimezone(doc, timezone) {
        return __awaiter(this, void 0, void 0, function* () {
            yield accountSettingsCollection(conn).updateOne({ accountId: doc.accountId }, { $set: { timezone } }, { session: conn.session });
        });
    },
    addApiSecurityToken(doc, token) {
        return __awaiter(this, void 0, void 0, function* () {
            yield accountSettingsCollection(conn).updateOne({ accountId: doc.accountId }, { $push: { apiSecurityTokens: token } }, { session: conn.session });
        });
    },
    removeApiSecurityToken(doc, id) {
        return __awaiter(this, void 0, void 0, function* () {
            yield accountSettingsCollection(conn).updateOne({ accountId: doc.accountId }, {
                $pull: { apiSecurityTokens: { id } },
            }, { session: conn.session });
        });
    },
    clearApiSecurityTokens(doc) {
        return __awaiter(this, void 0, void 0, function* () {
            const filter = {
                accountId: doc.accountId,
            };
            yield accountSettingsCollection(conn).updateOne(filter, {
                $pull: { apiSecurityTokens: { organizationUid: { $eq: null } } },
            }, { session: conn.session });
        });
    },
    updatePasswordSecurityTokenAndDate(doc, passwordSecurityToken, createdAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield accountSettingsCollection(conn).updateOne({ accountId: doc.accountId }, {
                $set: { passwordSecurity: { token: passwordSecurityToken, createdAt: createdAt } },
            }, { session: conn.session });
        });
    },
    invalidatePasswordSecurityToken(doc) {
        return __awaiter(this, void 0, void 0, function* () {
            yield accountSettingsCollection(conn).updateOne({ accountId: doc.accountId }, {
                $unset: { passwordSecurity: '' },
            }, { session: conn.session });
        });
    },
    updateEmailNotificationsAlertLevel(doc, alertLevels) {
        return __awaiter(this, void 0, void 0, function* () {
            yield accountSettingsCollection(conn).updateOne({ accountId: doc.accountId }, {
                $set: { 'email.notificationAlertLevels': alertLevels },
            }, { session: conn.session });
        });
    },
    updateEmailNotificationsNewsletter(doc, isSubscribedToNewsletter) {
        return __awaiter(this, void 0, void 0, function* () {
            yield accountSettingsCollection(conn).updateOne({ accountId: doc.accountId }, {
                $set: { 'email.isSubscribedToNewsletter': isSubscribedToNewsletter },
            }, { session: conn.session });
        });
    },
    updateWelcomeDashboardSectionsAppearance(doc, sectionsAppearance) {
        return __awaiter(this, void 0, void 0, function* () {
            let updateObject = {};
            for (const key in sectionsAppearance) {
                updateObject[`welcomeDashboard.sectionsAppearance.${key}`] = sectionsAppearance[key];
            }
            yield accountSettingsCollection(conn).updateOne({ accountId: doc.accountId }, {
                $set: updateObject,
            }, { session: conn.session });
        });
    },
});
exports.createAccountSettingsModel = createAccountSettingsModel;
//# sourceMappingURL=accountSettingsModel.js.map