"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPaginationAndSorting = exports.getSorting = void 0;
const paginationTypes_1 = require("./paginationTypes");
function getSorting({ defaultSorting, sorting, }) {
    var _a, _b;
    return {
        field: (_a = sorting === null || sorting === void 0 ? void 0 : sorting.field) !== null && _a !== void 0 ? _a : defaultSorting.field,
        order: (_b = sorting === null || sorting === void 0 ? void 0 : sorting.order) !== null && _b !== void 0 ? _b : defaultSorting.order,
    };
}
exports.getSorting = getSorting;
function createPaginationAndSorting(paginationAndSorting = {}) {
    validatePaginationAndSorting(paginationAndSorting);
    return paginationAndSorting;
}
exports.createPaginationAndSorting = createPaginationAndSorting;
function validatePaginationAndSorting({ pagination, sorting }) {
    if (pagination === undefined) {
        return;
    }
    if (sorting === undefined || sorting.order === undefined) {
        validatePaginationDefaultSorting(pagination);
    }
    else if (sorting.order === paginationTypes_1.SortOrder.ASC) {
        validatePaginationAscSorting(pagination);
    }
    else if (sorting.order === paginationTypes_1.SortOrder.DESC) {
        validatePaginationDescSorting(pagination);
    }
}
function validatePaginationDefaultSorting(pagination) {
    if ((0, paginationTypes_1.isLinkPagination)(pagination)) {
        throw new Error('Link pagination requires explicit sorting order');
    }
}
function validatePaginationAscSorting(pagination) {
    if ((0, paginationTypes_1.isLinkPagination)(pagination) && (pagination.since === undefined || pagination.until !== undefined)) {
        throw new Error('Link pagination with ascending sorting must have "since" defined and not "until"');
    }
}
function validatePaginationDescSorting(pagination) {
    if ((0, paginationTypes_1.isLinkPagination)(pagination) && (pagination.until === undefined || pagination.since !== undefined)) {
        throw new Error('Link pagination with ascending sorting must have "until" defined and not "since"');
    }
}
//# sourceMappingURL=pagination.js.map