import { IMongodbConnection } from '@signageos/lib/dist/MongoDB/mongoDBConnectionFactory';
/**
 * Convenient factory to generate fixtures data and persist them in some underlying storage
 */
export interface IPersistentFixturesFactory<TEntity, TCustomFields extends Partial<TEntity> = Partial<TEntity>, TDependencies extends {} = {}> {
    /**
     * Create one fixture object
     *
     * By default, values for all mandatory keys are randomly generated.
     * Specific values can be specified in ptops.customFields to overwrite the defaults.
     */
    create(props: TDependencies & {
        customFields?: TCustomFields;
    }): Promise<TEntity>;
    /**
     * Creates a list of fixture objects.
     *
     * The number of created fixtures is determined by props.count.
     */
    createMany(props: TDependencies & {
        count: number;
    }): Promise<TEntity[]>;
}
/**
 * Creates a fixtures factory that persists created fixtures in MongoDB
 */
export declare function createMongoFixturesFactory<TEntity, TCustomFields extends Partial<TEntity> = Partial<TEntity>, TDependencies extends {} = {}>({ mongodbConnection, collection, createEntity, }: {
    mongodbConnection: IMongodbConnection;
    collection: string;
    createEntity: (props: TDependencies & {
        customFields?: TCustomFields;
    }) => TEntity;
}): IPersistentFixturesFactory<TEntity, TCustomFields, TDependencies>;
//# sourceMappingURL=persistentFixturesFactory.d.ts.map