/**
 * Convenient factory to generate fixtures data
 */
export interface IFixturesFactory<TEntity, TCustomFields extends Partial<TEntity> = Partial<TEntity>, TDependencies extends {} = {}> {
    /**
     * Create one fixture object
     *
     * By default, values for all mandatory keys are randomly generated.
     * Specific values can be specified in props.customFields to overwrite the defaults.
     */
    create(props: TDependencies & {
        customFields?: TCustomFields;
    }): TEntity;
    /**
     * Creates a list of fixture objects.
     *
     * The number of created fixtures is determined by props.count.
     */
    createMany(props: TDependencies & {
        count: number;
    }): TEntity[];
}
/**
 * Creates a fixtures factory that simply generates and returns fixtures
 */
export declare function createFixturesFactory<TEntity, TCustomFields extends Partial<TEntity> = Partial<TEntity>, TDependencies extends {} = {}>({ createEntity, }: {
    createEntity: (props: TDependencies & {
        customFields?: TCustomFields;
    }) => TEntity;
}): IFixturesFactory<TEntity, TCustomFields, TDependencies>;
//# sourceMappingURL=fixturesFactory.d.ts.map