import { ITimestamp } from '@signageos/lib/dist/AMQP/CQRS/commandQueue';
import { IDomainModel } from '../../Schema/EventSourcing/domainModel';
import { IConsistencyOptions } from './consistency';
export interface ISynchronizedValues {
    timestamp: ITimestamp;
}
/**
 * Based on timestamp, we can wait for all database consumers to be synchronized.
 * So in case the options are set to 'strong' consistency,
 * the response waitSynchronized is resolved only when the database wrote all changes.
 */
export declare function prepareCommandSynchronization(domainModel: IDomainModel, consistencyOptions: IConsistencyOptions | undefined): Promise<{
    waitSynchronized(values: ISynchronizedValues): Promise<void>;
    finalize(): Promise<void>;
}>;
//# sourceMappingURL=commandSynchronization.d.ts.map