"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createCommandModel = void 0;
const commandFactory_1 = require("./commandFactory");
const commandModel_tools_1 = require("./commandModel.tools");
const EXPERIMENTAL_PREFIX = '_experimental_';
function createCommandModel(options, commandDispatcher, commandExports, commandOptions) {
    const model = {};
    for (const exportName in commandExports) {
        let methodName = (0, commandModel_tools_1.extractMethodName)(options, exportName);
        if (!methodName) {
            const experimentalMethodName = (0, commandModel_tools_1.extractMethodName)({ entityNameSingular: ``, entityNamePlural: `List` }, exportName);
            if (experimentalMethodName) {
                methodName = EXPERIMENTAL_PREFIX + experimentalMethodName;
            }
        }
        if (methodName) {
            model[methodName] = function (data, opts) {
                return __awaiter(this, void 0, void 0, function* () {
                    const commandFactory = commandExports[exportName];
                    const payload = commandFactory(data);
                    const command = yield (0, commandFactory_1.createCommand)(payload, commandOptions);
                    yield commandDispatcher.dispatch(command, opts === null || opts === void 0 ? void 0 : opts.messageOptions, opts === null || opts === void 0 ? void 0 : opts.consistencyOptions);
                    return command.payload;
                });
            };
        }
    }
    return model;
}
exports.createCommandModel = createCommandModel;
//# sourceMappingURL=commandModelFactory.js.map