import { ICommandPayload } from '@signageos/lib/dist/AMQP/CQRS/ICommand';
import IMessageOptions from '@signageos/lib/dist/AMQP/IMessageOptions';
import { ICommandDispatcher } from './commandDispatcher';
import { IConsistencyOptions } from './consistency';
import { ICommandOptions } from './commandFactory';
import { ExtractMethodName, FactoryNameLiteral } from './commandModel.tools';
declare const EXPERIMENTAL_PREFIX = "_experimental_";
declare type CommandFactoryOptions = {
    messageOptions?: IMessageOptions;
    consistencyOptions?: IConsistencyOptions;
};
declare type CommandFactory<TCommand extends ICommandPayload> = (data: any) => TCommand;
declare type CommandExports<TEntityNameSingular extends string, TEntityNamePlural extends string, TCommand extends ICommandPayload> = {
    [FactoryName in FactoryNameLiteral<TEntityNameSingular | TEntityNamePlural, string, string>]: CommandFactory<TCommand>;
} & {
    [ExperimentalFactoryName in FactoryNameLiteral<`` | `List`, string, string>]: CommandFactory<TCommand>;
} & {
    [exportName: string]: unknown;
};
export declare type CommandModel<TEntityNameSingular extends string, TEntityNamePlural extends string, TCommandExports extends CommandExports<TEntityNameSingular, TEntityNamePlural, TCommand>, TCommand extends ICommandPayload> = {
    [ExportName in keyof TCommandExports as ExportName extends FactoryNameLiteral<TEntityNameSingular, string, string> ? `${ExtractMethodName<TEntityNameSingular, TEntityNamePlural, ExportName>}` : `${typeof EXPERIMENTAL_PREFIX}${ExtractMethodName<``, `List`, ExportName>}`]: TCommandExports[ExportName] extends CommandFactory<TCommand> ? (data: Parameters<TCommandExports[ExportName]>[0], options?: CommandFactoryOptions) => Promise<ReturnType<TCommandExports[ExportName]>> : never;
};
export declare function createCommandModel<TEntityNameSingular extends string, TEntityNamePlural extends string, TCommandExports extends CommandExports<TEntityNameSingular, TEntityNamePlural, TCommand>, TCommand extends ICommandPayload>(options: {
    entityNameSingular: TEntityNameSingular;
    entityNamePlural: TEntityNamePlural;
}, commandDispatcher: ICommandDispatcher, commandExports: TCommandExports, commandOptions: ICommandOptions): CommandModel<TEntityNameSingular, TEntityNamePlural, TCommandExports, TCommand>;
export {};
//# sourceMappingURL=commandModelFactory.d.ts.map