"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractMethodName = void 0;
const word_1 = require("@signageos/lib/dist/String/word");
function extractMethodName(options, exportName) {
    const matches0 = exportName.match(new RegExp(`^(.+)${options.entityNamePlural}(.+)Factory$`));
    if (matches0) {
        return (0, word_1.uncapitalize)(matches0[1] + 'Many' + matches0[2]);
    }
    const matches1 = exportName.match(new RegExp(`^(.+)${options.entityNamePlural}Factory$`));
    if (matches1) {
        return (0, word_1.uncapitalize)(matches1[1] + 'Many');
    }
    const matches2 = exportName.match(new RegExp(`^(.+)${options.entityNameSingular}(.+)Factory$`));
    if (matches2) {
        return (0, word_1.uncapitalize)(matches2[1] + matches2[2]);
    }
    const matches3 = exportName.match(new RegExp(`^(.+)${options.entityNameSingular}Factory$`));
    if (matches3) {
        return (0, word_1.uncapitalize)(matches3[1]);
    }
    return null;
}
exports.extractMethodName = extractMethodName;
//# sourceMappingURL=commandModel.tools.js.map