import { Context } from '@signageos/commands/dist/Context/context';
import ICommand, { ICommandPayload } from '@signageos/lib/dist/AMQP/CQRS/ICommand';
export interface ICommandOptions {
    sourceUid: string;
    /**
     * Context will be included in payload of all commands
     *
     * It's used to attach additional metadata about the environment that may alter the result of the command.
     * It may also be a Promise in case the context is not available immediately.
     *
     * For example: let's say there's context that contains whiteLabelSettingsUid.
     * If a command produces event that is consumed by a mailing service,
     * then whiteLabelSettingsUid will be passed from command's context to that event
     * so that the mailing service will know that it should use whitelabeled email template.
     *
     * Of course, it's not the concern of the command producer, how context will be used by the command consumer.
     * The producer has to simply pass the context and let the consumer decide what to do with it.
     * The above example is described just to illustrate, what it's for down the line.
     */
    context?: Context | Promise<Context>;
}
export declare function createCommand<P extends ICommandPayload<string>>(payload: P, { sourceUid, context }: ICommandOptions): Promise<ICommand<P>>;
//# sourceMappingURL=commandFactory.d.ts.map