import { Point } from '@influxdata/influxdb-client';
import { IDeviceMonitoringLog, IDeviceMonitoringLogFilter } from '../../../Schema/Device/MonitoringLog/deviceMonitoringLogModel';
import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import { MonitoringLogData } from '@signageos/common-types/dist/Device/MonitoringLog/MonitoringLogData';
export interface IQueryable {
    getLastValueQuery(bucket: string, deviceIdentityHash: string): string;
    getValuesQuery(bucket: string, deviceIdentityHash: string, filter: IDeviceMonitoringLogFilter): string;
    getValuesSinceQuery(bucket: string, deviceIdentityHash: string, since: Date): string;
    getValuesQueryPivoted(bucket: string, deviceIdentityHash: string, since: Date, until: Date, limit?: number): string;
    getLastNValuesQuery(bucket: string, deviceIdentityHash: string, n: number): string;
    getLastValuesSinceQuery(bucket: string, deviceIdentityHashes: string[], since: Date): string;
}
export interface ITransformable<T extends DeviceTelemetryType> {
    transformPivoted(rows: unknown[]): IDeviceMonitoringLog<T>[];
}
export declare function createQueryable<T extends DeviceTelemetryType>(type: T): IQueryable & ITransformable<T>;
export interface IMonitoringPoint {
    create<T extends DeviceTelemetryType>(point: Point, type: T, id: string, data: MonitoringLogData[T]): Point;
}
export declare const monitoringPointCreator: IMonitoringPoint;
//# sourceMappingURL=helper.d.ts.map