"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitForFirstNonNull = exports.waitForFirst = void 0;
function waitForFirst(observer, timeoutMs = 30e3) {
    let timeoutTimer = undefined;
    let subscriber = undefined;
    let rejectCallback = undefined;
    function cancelTimeout() {
        if (timeoutTimer) {
            clearTimeout(timeoutTimer);
            timeoutTimer = undefined;
        }
    }
    function cancelSubscription() {
        if (subscriber) {
            subscriber.unsubscribe();
            subscriber = undefined;
        }
    }
    function rejectPromise(error) {
        if (rejectCallback) {
            rejectCallback(error);
            rejectCallback = undefined;
        }
    }
    const promise = new Promise((resolve, reject) => {
        rejectCallback = reject;
        timeoutTimer = setTimeout(() => {
            cancelSubscription();
            rejectPromise(new Error('Wait for first data timed-out'));
        }, timeoutMs);
        subscriber = observer.subscribe((data) => {
            cancelSubscription();
            cancelTimeout();
            resolve(data);
        }, (error) => {
            cancelSubscription();
            cancelTimeout();
            rejectPromise(error);
        }, () => {
            cancelSubscription();
            cancelTimeout();
            rejectPromise(new Error('No data came'));
        });
    });
    promise.cancel = () => {
        cancelSubscription();
        cancelTimeout();
        rejectPromise(new Error('Wait for first data cancelled'));
    };
    return promise;
}
exports.waitForFirst = waitForFirst;
function waitForFirstNonNull(observer, timeoutMs = 30e3) {
    const nonNullObservable = observer.filter((value) => value !== null);
    return waitForFirst(nonNullObservable, timeoutMs);
}
exports.waitForFirstNonNull = waitForFirstNonNull;
//# sourceMappingURL=observation.js.map