import { IUITheme } from '../../Schema/UITheme/uiThemeModel';
import { ITermsAndConditions } from '../../Schema/TermsAndConditions/termsAndConditionsModel';
import { IWhiteLabelSettings } from '../../Schema/WhiteLabelSettings/whiteLabelSettingsModel';
export declare type CustomFields = Partial<Omit<IWhiteLabelSettings, 'uiThemeUid'>>;
export interface CreateProps {
    uiTheme: IUITheme;
    termsAndConditions?: ITermsAndConditions;
    customFields?: CustomFields;
}
export declare function createWhiteLabelSettings({ uiTheme, termsAndConditions, customFields }: CreateProps): IWhiteLabelSettings;
export declare function createWhiteLabelSettingsFixturesFactories(): {
    createSimpleFactory(): import("../../Lib/Fixtures/fixturesFactory").IFixturesFactory<IWhiteLabelSettings, Partial<Omit<IWhiteLabelSettings, "uiThemeUid">>, CreateProps & {
        customFields?: Partial<Omit<IWhiteLabelSettings, "uiThemeUid">> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<IWhiteLabelSettings, Partial<Omit<IWhiteLabelSettings, "uiThemeUid">>, CreateProps & {
        customFields?: Partial<Omit<IWhiteLabelSettings, "uiThemeUid">> | undefined;
    }>;
};
//# sourceMappingURL=whiteLabelSettingsFixtures.d.ts.map