import { IApplet } from '../../Schema/Applet/appletModel';
import { IDevice } from '../../Schema/Device/deviceModel';
import { ITiming } from '../../Schema/Timing/timingModel';
export declare type CustomFields = Partial<ITiming>;
export interface CreateProps {
    customFields?: CustomFields;
    applet: IApplet;
    device: IDevice;
}
export declare function createTiming({ applet, device, customFields }: CreateProps): ITiming;
export declare function createTimingFixturesFactories(): {
    createSimpleFactory(): import("../../Lib/Fixtures/fixturesFactory").IFixturesFactory<ITiming, Partial<ITiming>, CreateProps & {
        customFields?: Partial<ITiming> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<ITiming, Partial<ITiming>, CreateProps & {
        customFields?: Partial<ITiming> | undefined;
    }>;
};
//# sourceMappingURL=timingFixtures.d.ts.map