"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTermsAndConditionsVersionFixturesFactories = exports.createTermsAndConditionsVersion = void 0;
const faker_1 = require("@faker-js/faker");
const collections_1 = require("../../Mongo/Lib/collections");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
const createTermsAndConditionsVersion = ({ termsAndConditions, customFields, }) => {
    const createdAt = faker_1.default.date.past();
    return Object.assign({ uid: faker_1.default.datatype.uuid(), termsAndConditionsUid: termsAndConditions.uid, url: faker_1.default.internet.url(), version: faker_1.default.datatype.uuid(), createdAt, updatedAt: faker_1.default.date.between(createdAt, new Date()) }, customFields);
};
exports.createTermsAndConditionsVersion = createTermsAndConditionsVersion;
function createTermsAndConditionsVersionFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.TermsAndConditionsVersion,
        createEntity: exports.createTermsAndConditionsVersion,
    });
}
exports.createTermsAndConditionsVersionFixturesFactories = createTermsAndConditionsVersionFixturesFactories;
//# sourceMappingURL=termsAndConditionsVersionFixtures.js.map