"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPolicyFixturesFactories = exports.createPolicy = void 0;
const faker_1 = require("@faker-js/faker");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
const collections_1 = require("../../Mongo/Lib/collections");
function createPolicy({ organization, customFields }) {
    var _a;
    return Object.assign({ organizationUid: organization.uid, uid: faker_1.default.datatype.uuid(), name: faker_1.default.hacker.noun(), items: (_a = customFields === null || customFields === void 0 ? void 0 : customFields.items) !== null && _a !== void 0 ? _a : [] }, customFields);
}
exports.createPolicy = createPolicy;
function createPolicyFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.Policy,
        createEntity: createPolicy,
    });
}
exports.createPolicyFixturesFactories = createPolicyFixturesFactories;
//# sourceMappingURL=policyFixtures.js.map