import { IPackage } from '../../Schema/Package/packageModel';
import { IPackageVersion } from '../../Schema/Package/packageVersionModel';
export declare type CustomFields = Partial<Omit<IPackageVersion, 'packageName'>>;
export interface CreateProps {
    packageObject: IPackage;
    customFields?: CustomFields;
}
export declare function createPackageVersion({ packageObject, customFields }: CreateProps): IPackageVersion;
export declare function createPackageVersionFixturesFactories(): {
    createSimpleFactory(): import("../../Lib/Fixtures/fixturesFactory").IFixturesFactory<IPackageVersion, Partial<Omit<IPackageVersion, "packageName">>, CreateProps & {
        customFields?: Partial<Omit<IPackageVersion, "packageName">> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<IPackageVersion, Partial<Omit<IPackageVersion, "packageName">>, CreateProps & {
        customFields?: Partial<Omit<IPackageVersion, "packageName">> | undefined;
    }>;
};
//# sourceMappingURL=packageVersionFixtures.d.ts.map