"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createOrganizationTagFixturesFactories = exports.createOrganizationTag = void 0;
const faker_1 = require("@faker-js/faker");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
const collections_1 = require("../../Mongo/Lib/collections");
const generators_1 = require("@signageos/commands/dist/generators");
function createOrganizationTag({ tagObject, customFields }) {
    return Object.assign({ uid: (0, generators_1.uid)(), name: tagObject.name, organizationUid: tagObject.organizationUid, createdAt: faker_1.faker.datatype.datetime(), updatedAt: faker_1.faker.datatype.datetime() }, customFields);
}
exports.createOrganizationTag = createOrganizationTag;
function createOrganizationTagFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.OrganizationTag,
        createEntity: createOrganizationTag,
    });
}
exports.createOrganizationTagFixturesFactories = createOrganizationTagFixturesFactories;
//# sourceMappingURL=organizationTagFixtures.js.map