"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createFeatureFixture = exports.createLocationFixturesFactories = exports.createLocation = void 0;
const uid_1 = require("@signageos/common-types/dist/Entity/uid");
const faker_1 = require("@faker-js/faker");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
const collections_1 = require("../../Mongo/Lib/collections");
function createLocation({ organization, customFields }) {
    return Object.assign({ uid: (0, uid_1.generateUid)(), name: faker_1.faker.random.word(), city: faker_1.faker.address.city(), countryCode: faker_1.faker.address.countryCode(), feature: createFeatureFixture({}), organizationUid: organization.uid, createdAt: faker_1.faker.date.past(), updatedAt: faker_1.faker.date.past(), attachments: [] }, customFields);
}
exports.createLocation = createLocation;
function createLocationFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.Location,
        createEntity: createLocation,
    });
}
exports.createLocationFixturesFactories = createLocationFixturesFactories;
function createFeatureFixture({ state, country }) {
    return {
        type: 'Feature',
        geometry: {
            type: 'Point',
            coordinates: [parseInt(faker_1.faker.address.longitude()), parseInt(faker_1.faker.address.latitude())],
        },
        properties: {
            context: [
                {
                    id: `region.${faker_1.faker.random.numeric(17)}`,
                    wikidata: `Q${faker_1.faker.random.numeric(3)}`,
                    short_code: faker_1.faker.random.alpha(3),
                    text: state !== null && state !== void 0 ? state : faker_1.faker.address.state(),
                },
                {
                    id: `country.${faker_1.faker.random.numeric(17)}`,
                    wikidata: `Q${faker_1.faker.random.numeric(3)}`,
                    short_code: faker_1.faker.random.alpha(3),
                    text: country !== null && country !== void 0 ? country : faker_1.faker.address.country(),
                },
            ],
        },
    };
}
exports.createFeatureFixture = createFeatureFixture;
//# sourceMappingURL=locationFixtures.js.map