"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createOwnServerLicenseValidityFixturesFactories = exports.createOwnServerLicenseValidity = void 0;
const faker_1 = require("@faker-js/faker");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
const collections_1 = require("../../Mongo/Lib/collections");
function createOwnServerLicenseValidity({ ownServerLicense, customFields }) {
    return Object.assign({ id: faker_1.faker.datatype.uuid(), ownServerLicenseId: ownServerLicense.id, createdAt: faker_1.faker.date.past(), expireAt: faker_1.faker.date.future(), license: faker_1.faker.datatype.string(), signature: faker_1.faker.datatype.string() }, customFields);
}
exports.createOwnServerLicenseValidity = createOwnServerLicenseValidity;
function createOwnServerLicenseValidityFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.OwnServerLicenseValidity,
        createEntity: createOwnServerLicenseValidity,
    });
}
exports.createOwnServerLicenseValidityFixturesFactories = createOwnServerLicenseValidityFixturesFactories;
//# sourceMappingURL=ownServerLicenseValidityFixtures.js.map