"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createOwnServerLicenseFixturesFactories = exports.createOwnServerLicense = void 0;
const faker_1 = require("@faker-js/faker");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
const collections_1 = require("../../Mongo/Lib/collections");
function createOwnServerLicense({ customFields }) {
    return Object.assign({ id: faker_1.faker.datatype.uuid(), oauthClientId: faker_1.faker.datatype.uuid(), oauthClientSecret: faker_1.faker.datatype.string(), serverBaseUrl: faker_1.faker.internet.url(), licenseKey: faker_1.faker.datatype.string(), licenseSecret: faker_1.faker.datatype.string(), createdAt: faker_1.faker.date.past() }, customFields);
}
exports.createOwnServerLicense = createOwnServerLicense;
function createOwnServerLicenseFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.OwnServerLicense,
        createEntity: createOwnServerLicense,
    });
}
exports.createOwnServerLicenseFixturesFactories = createOwnServerLicenseFixturesFactories;
//# sourceMappingURL=ownServerLicenseFixtures.js.map