"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createIssuedDeviceLicenseFixturesFactories = exports.createIssuedDeviceLicense = void 0;
const faker_1 = require("@faker-js/faker");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
const collections_1 = require("../../Mongo/Lib/collections");
const subscription_1 = require("@signageos/common-types/dist/Subscription/subscription");
function createIssuedDeviceLicense({ device, sourceIssuedServerLicenseValidity, customFields }) {
    return Object.assign({ id: faker_1.faker.datatype.uuid(), duid: device.uid, applicationType: device.applicationType, sourceIssuedServerLicenseValidityId: sourceIssuedServerLicenseValidity.id, createdAt: faker_1.faker.date.past(), subscriptionType: subscription_1.SubscriptionType.All }, customFields);
}
exports.createIssuedDeviceLicense = createIssuedDeviceLicense;
function createIssuedDeviceLicenseFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.IssuedDeviceLicense,
        createEntity: createIssuedDeviceLicense,
    });
}
exports.createIssuedDeviceLicenseFixturesFactories = createIssuedDeviceLicenseFixturesFactories;
//# sourceMappingURL=issuedDeviceLicenseFixtures.js.map