import { IIssuedDeviceLicense } from '../../Schema/License/issuedDeviceLicenseModel';
import { IDevice } from '../../Schema/Device/deviceModel';
import { IIssuedServerLicenseValidity } from '../../Schema/License/issuedServerLicenseValidityModel';
export declare type CustomFields = Partial<Omit<IIssuedDeviceLicense, 'organizationUid'>>;
export interface CreateProps {
    device: IDevice;
    sourceIssuedServerLicenseValidity: IIssuedServerLicenseValidity;
    customFields?: CustomFields;
}
export declare function createIssuedDeviceLicense({ device, sourceIssuedServerLicenseValidity, customFields }: CreateProps): IIssuedDeviceLicense;
export declare function createIssuedDeviceLicenseFixturesFactories(): {
    createSimpleFactory(): import("../../Lib/Fixtures/fixturesFactory").IFixturesFactory<IIssuedDeviceLicense, Partial<Omit<IIssuedDeviceLicense, "organizationUid">>, CreateProps & {
        customFields?: Partial<Omit<IIssuedDeviceLicense, "organizationUid">> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<IIssuedDeviceLicense, Partial<Omit<IIssuedDeviceLicense, "organizationUid">>, CreateProps & {
        customFields?: Partial<Omit<IIssuedDeviceLicense, "organizationUid">> | undefined;
    }>;
};
//# sourceMappingURL=issuedDeviceLicenseFixtures.d.ts.map