import { IDevice } from '../../Schema/Device/deviceModel';
import { IDeviceVerification } from '../../Schema/Device/Verification/deviceVerificationModel';
export declare type CustomFields = Partial<Omit<IDeviceVerification, 'deviceIdentityHash'>>;
export interface CreateProps {
    device: IDevice;
    customFields?: CustomFields;
}
export declare function createDeviceVerification({ device, customFields }: CreateProps): IDeviceVerification;
export declare function createDeviceVerificationFixturesFactories(): {
    createSimpleFactory(): import("../../Lib/Fixtures/fixturesFactory").IFixturesFactory<IDeviceVerification, Partial<Omit<IDeviceVerification, "deviceIdentityHash">>, CreateProps & {
        customFields?: Partial<Omit<IDeviceVerification, "deviceIdentityHash">> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<IDeviceVerification, Partial<Omit<IDeviceVerification, "deviceIdentityHash">>, CreateProps & {
        customFields?: Partial<Omit<IDeviceVerification, "deviceIdentityHash">> | undefined;
    }>;
};
//# sourceMappingURL=deviceVerificationFixtures.d.ts.map