"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceFixturesFactories = exports.createDevice = void 0;
const faker_1 = require("@faker-js/faker");
const collections_1 = require("../../Mongo/Lib/collections");
const applicationType_1 = require("../Application/applicationType");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
function createDevice({ organization, customFields }) {
    return Object.assign({ name: faker_1.faker.hacker.adjective(), uid: faker_1.faker.datatype.uuid(), identityHash: faker_1.faker.datatype.uuid(), createdAt: faker_1.faker.datatype.datetime(), organizationUid: organization.uid, applicationType: (0, applicationType_1.randomApplicationType)(), firmwareVersion: faker_1.faker.datatype.uuid(), model: faker_1.faker.datatype.uuid(), serialNumber: faker_1.faker.datatype.uuid(), locationUid: faker_1.faker.datatype.uuid() }, customFields);
}
exports.createDevice = createDevice;
function createDeviceFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.DeviceCollection.Device,
        createEntity: createDevice,
    });
}
exports.createDeviceFixturesFactories = createDeviceFixturesFactories;
//# sourceMappingURL=deviceFixtures.js.map