import { IDevice } from '../../Schema/Device/deviceModel';
import { IOrganization } from '../../Schema/Organization/organizationModel';
export declare type CustomFields = Partial<IDevice>;
export interface CreateProps {
    organization: IOrganization;
    customFields?: CustomFields;
}
export declare function createDevice({ organization, customFields }: CreateProps): IDevice;
export declare function createDeviceFixturesFactories(): {
    createSimpleFactory(): import("../../Lib/Fixtures/fixturesFactory").IFixturesFactory<IDevice, Partial<IDevice>, CreateProps & {
        customFields?: Partial<IDevice> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<IDevice, Partial<IDevice>, CreateProps & {
        customFields?: Partial<IDevice> | undefined;
    }>;
};
//# sourceMappingURL=deviceFixtures.d.ts.map