"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createScreenshotFixturesFactories = exports.createScreenshot = void 0;
const faker_1 = require("@faker-js/faker");
const collections_1 = require("../../../Mongo/Lib/collections");
const fixturesFactories_1 = require("../../../Lib/Fixtures/fixturesFactories");
function createScreenshot({ device, customFields }) {
    return Object.assign({ id: faker_1.faker.datatype.uuid(), deviceIdentityHash: device.identityHash, takenAt: faker_1.faker.datatype.datetime(), uri: faker_1.faker.image.imageUrl() }, customFields);
}
exports.createScreenshot = createScreenshot;
function createScreenshotFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.DeviceCollection.Screenshot,
        createEntity: createScreenshot,
    });
}
exports.createScreenshotFixturesFactories = createScreenshotFixturesFactories;
//# sourceMappingURL=screenshotFixtures.js.map