"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceProvisioningRecipeFixturesFactories = exports.createDeviceProvisioningRecipe = void 0;
const fixturesFactories_1 = require("../../../Lib/Fixtures/fixturesFactories");
const collections_1 = require("../../../Mongo/Lib/collections");
const deviceProvisioningRecipe_1 = require("@signageos/common-types/dist/Device/ProvisioningRecipe/deviceProvisioningRecipe");
const uid_1 = require("@signageos/common-types/dist/Entity/uid");
const faker_1 = require("@faker-js/faker");
function createDeviceProvisioningRecipe({ organization, policy, location, customFields }) {
    return Object.assign({ uid: (0, uid_1.generateUid)(), organizationUid: organization.uid, serialNumber: faker_1.faker.random.alphaNumeric(10), macAddress: faker_1.faker.internet.mac(), model: faker_1.faker.random.word(), brand: faker_1.faker.random.word(), tagUids: [], policyUid: policy === null || policy === void 0 ? void 0 : policy.uid, locationUid: location === null || location === void 0 ? void 0 : location.uid, status: deviceProvisioningRecipe_1.DeviceProvisioningRecipeStatus.PENDING, createdAt: faker_1.faker.date.past(), updatedAt: faker_1.faker.date.past() }, customFields);
}
exports.createDeviceProvisioningRecipe = createDeviceProvisioningRecipe;
function createDeviceProvisioningRecipeFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.DeviceCollection.DeviceProvisioningRecipe,
        createEntity: createDeviceProvisioningRecipe,
    });
}
exports.createDeviceProvisioningRecipeFixturesFactories = createDeviceProvisioningRecipeFixturesFactories;
//# sourceMappingURL=deviceProvisioningRecipeFixtures.js.map