import { IDeviceProvisioningRecipe } from '../../../Schema/Device/ProvisioningRecipe/deviceProvisioningRecipeModel';
import { IOrganization } from '../../../Schema/Organization/organizationModel';
import { IDevice } from '../../../Schema/Device/deviceModel';
import { IPolicy } from '../../../Schema/Policy/policyModel';
import { ILocation } from '../../../Schema/Location/locationModel';
export declare type CustomFields = Partial<IDeviceProvisioningRecipe>;
export interface CreateProps {
    customFields?: CustomFields;
    organization: IOrganization;
    device?: IDevice;
    policy?: IPolicy;
    location?: ILocation;
}
export declare function createDeviceProvisioningRecipe({ organization, policy, location, customFields }: CreateProps): IDeviceProvisioningRecipe;
export declare function createDeviceProvisioningRecipeFixturesFactories(): {
    createSimpleFactory(): import("../../../Lib/Fixtures/fixturesFactory").IFixturesFactory<IDeviceProvisioningRecipe, Partial<IDeviceProvisioningRecipe>, CreateProps & {
        customFields?: Partial<IDeviceProvisioningRecipe> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<IDeviceProvisioningRecipe, Partial<IDeviceProvisioningRecipe>, CreateProps & {
        customFields?: Partial<IDeviceProvisioningRecipe> | undefined;
    }>;
};
//# sourceMappingURL=deviceProvisioningRecipeFixtures.d.ts.map