"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDevicePowerActionFixturesFactories = exports.createDevicePowerAction = void 0;
const faker_1 = require("@faker-js/faker");
const collections_1 = require("../../../Mongo/Lib/collections");
const fixturesFactories_1 = require("../../../Lib/Fixtures/fixturesFactories");
const PowerActionType_1 = require("@signageos/common-types/dist/Device/Power/PowerActionType");
function createDevicePowerAction({ device, customFields }) {
    return Object.assign({ uid: faker_1.faker.datatype.uuid(), deviceIdentityHash: device.identityHash, powerType: PowerActionType_1.default.APP_RESTART, createdAt: faker_1.faker.date.past(), succeededAt: faker_1.faker.date.past(), failedAt: null }, customFields);
}
exports.createDevicePowerAction = createDevicePowerAction;
function createDevicePowerActionFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.DeviceCollection.PowerAction,
        createEntity: createDevicePowerAction,
    });
}
exports.createDevicePowerActionFixturesFactories = createDevicePowerActionFixturesFactories;
//# sourceMappingURL=devicePowerActionFixtures.js.map