import { IDevice } from '../../../Schema/Device/deviceModel';
import { IDevicePowerAction } from '../../../Schema/Device/PowerAction/devicePowerActionModel';
export declare type CustomFields = Partial<Omit<IDevicePowerAction, 'deviceIdentityHash'>>;
export interface CreateProps {
    device: IDevice;
    customFields?: CustomFields;
}
export declare function createDevicePowerAction({ device, customFields }: CreateProps): IDevicePowerAction;
export declare function createDevicePowerActionFixturesFactories(): {
    createSimpleFactory(): import("../../../Lib/Fixtures/fixturesFactory").IFixturesFactory<IDevicePowerAction, Partial<Omit<IDevicePowerAction, "deviceIdentityHash">>, CreateProps & {
        customFields?: Partial<Omit<IDevicePowerAction, "deviceIdentityHash">> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<IDevicePowerAction, Partial<Omit<IDevicePowerAction, "deviceIdentityHash">>, CreateProps & {
        customFields?: Partial<Omit<IDevicePowerAction, "deviceIdentityHash">> | undefined;
    }>;
};
//# sourceMappingURL=devicePowerActionFixtures.d.ts.map