"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceInfoFixturesFactories = exports.createDeviceInfo = void 0;
const faker_1 = require("@faker-js/faker");
const collections_1 = require("../../../Mongo/Lib/collections");
const fixturesFactories_1 = require("../../../Lib/Fixtures/fixturesFactories");
const deviceInfoModel_1 = require("../../../Mongo/Device/Info/deviceInfoModel");
// minStorageStatusFreeSpacePercentage is in type IDeviceInfo, but is passed to mongo when updating storageStatus
function createDeviceInfo({ device, customFields }) {
    const storageStatus = {
        internal: {
            capacity: faker_1.faker.datatype.number(),
            freeSpace: faker_1.faker.datatype.number(),
        },
        removable: {
            capacity: faker_1.faker.datatype.number(),
            freeSpace: faker_1.faker.datatype.number(),
        },
        updatedAt: faker_1.faker.datatype.datetime(),
    };
    return Object.assign({ identityHash: device.identityHash, minStorageStatusFreeSpacePercentage: (0, deviceInfoModel_1.getDeviceFreeStorageStatusPercentage)(customFields && customFields.storageStatus ? customFields.storageStatus : storageStatus), storageStatus, batteryStatus: {
            percentage: 100,
            chargeType: faker_1.faker.random.word(),
            isCharging: faker_1.faker.datatype.boolean(),
            lastChargingTime: faker_1.faker.date.recent(),
            updatedAt: new Date(),
        }, currentTime: { timestamp: Date.now(), timezoneOffset: 120, timezone: 'Europe/Prague', updatedAt: new Date() }, incorrectTime: faker_1.faker.datatype.boolean(), supportedResolutions: [
            {
                width: faker_1.faker.datatype.number(),
                height: faker_1.faker.datatype.number(),
                framerate: faker_1.faker.datatype.number(),
            },
        ], specs: {
            build: {
                version: {
                    release: faker_1.faker.datatype.string(),
                    sdk: faker_1.faker.datatype.number(),
                    codename: faker_1.faker.datatype.string(),
                },
                product: {
                    brand: faker_1.faker.datatype.string(),
                    model: faker_1.faker.datatype.string(),
                    supportedAbis: [faker_1.faker.datatype.string()],
                },
            },
            signatures: {
                framework: {
                    sha256: faker_1.faker.datatype.string(),
                },
            },
        }, policyItemTypes: [], proxy: {
            enabled: faker_1.faker.datatype.boolean(),
            uri: faker_1.faker.datatype.string(),
        } }, customFields);
}
exports.createDeviceInfo = createDeviceInfo;
function createDeviceInfoFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.DeviceCollection.Info,
        createEntity: createDeviceInfo,
    });
}
exports.createDeviceInfoFixturesFactories = createDeviceInfoFixturesFactories;
//# sourceMappingURL=deviceInfoFixtures.js.map