import { ICompanyNetwork } from '../../Schema/CompanyNetwork/companyNetworkModel';
import { IWhiteLabelSettings } from '../../Schema/WhiteLabelSettings/whiteLabelSettingsModel';
export declare type CustomFields = Partial<Omit<ICompanyNetwork, 'whiteLabelSettingsUid'>>;
export interface CreateProps {
    whiteLabelSettings?: IWhiteLabelSettings[];
    legacyWhiteLabelSettings?: IWhiteLabelSettings;
    customFields?: CustomFields;
}
export declare function createCompanyNetwork({ whiteLabelSettings, legacyWhiteLabelSettings, customFields }: CreateProps): ICompanyNetwork;
export declare function createCompanyNetworkFixturesFactories(): {
    createSimpleFactory(): import("../../Lib/Fixtures/fixturesFactory").IFixturesFactory<ICompanyNetwork, Partial<Omit<ICompanyNetwork, "whiteLabelSettingsUid">>, CreateProps & {
        customFields?: Partial<Omit<ICompanyNetwork, "whiteLabelSettingsUid">> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<ICompanyNetwork, Partial<Omit<ICompanyNetwork, "whiteLabelSettingsUid">>, CreateProps & {
        customFields?: Partial<Omit<ICompanyNetwork, "whiteLabelSettingsUid">> | undefined;
    }>;
};
//# sourceMappingURL=companyNetworkFixtures.d.ts.map