"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createBulkRequestedEventFixtureFactories = void 0;
const faker_1 = require("@faker-js/faker");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
const collections_1 = require("../../Mongo/Lib/collections");
function createBulkRequestedEvent({ device, bulkOperation, customFields, }) {
    return Object.assign({ requestUid: faker_1.faker.datatype.uuid(), sourceUid: bulkOperation.uid, deviceIdentityHash: device.identityHash, createdAt: faker_1.faker.date.past() }, customFields);
}
function createBulkRequestedEventFixtureFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.BulkRequestedEvents,
        createEntity: createBulkRequestedEvent,
    });
}
exports.createBulkRequestedEventFixtureFactories = createBulkRequestedEventFixtureFactories;
//# sourceMappingURL=bulkRequestedEventFixtures.js.map