"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createApplicationVersionFixturesFactories = exports.createApplicationVersion = void 0;
const faker_1 = require("@faker-js/faker");
const collections_1 = require("../../../Mongo/Lib/collections");
const fixturesFactories_1 = require("../../../Lib/Fixtures/fixturesFactories");
const applicationType_1 = require("../applicationType");
function createApplicationVersion({ customFields }) {
    return Object.assign({ uid: faker_1.faker.datatype.uuid(), application: (0, applicationType_1.randomApplicationType)(), frontDisplayVersion: faker_1.faker.system.semver(), version: faker_1.faker.system.semver(), createdAt: faker_1.faker.date.past(), publishedSince: faker_1.faker.date.past() }, customFields);
}
exports.createApplicationVersion = createApplicationVersion;
function createApplicationVersionFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.ApplicationVersion,
        createEntity: createApplicationVersion,
    });
}
exports.createApplicationVersionFixturesFactories = createApplicationVersionFixturesFactories;
//# sourceMappingURL=applicationVersionFixtures.js.map